/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.DialogComponentProvider;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.GTableColumnModel;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import util.CollectionUtils;

public class ChooseColumnsDialog
extends DialogComponentProvider {
    private GTable ghidraTable;
    private List<TableColumnWrapper> columnList;
    private Map<TableColumn, Boolean> selectedMap = new HashMap<TableColumn, Boolean>();
    private final GTableColumnModel columnModel;
    private boolean wasCancelled;

    ChooseColumnsDialog(GTableColumnModel columnModel, TableModel model) {
        super("Select Columns", true, true, true, false);
        this.columnModel = columnModel;
        this.initialize();
        SelectColumnsModel tableModel = new SelectColumnsModel();
        final Renderer renderer = new Renderer();
        this.ghidraTable = new GTable(tableModel){

            @Override
            protected TableColumnModel createDefaultColumnModel() {
                return new DefaultTableColumnModel();
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int col) {
                return renderer;
            }
        };
        this.ghidraTable.setAutoResizeMode(3);
        this.ghidraTable.setAutoLookupColumn(1);
        this.ghidraTable.getAccessibleContext().setAccessibleName("Columns");
        TableColumn enabledColumn = this.ghidraTable.getColumnModel().getColumn(0);
        int enabledColumnWidth = 50;
        enabledColumn.setPreferredWidth(enabledColumnWidth);
        enabledColumn.setMaxWidth(enabledColumnWidth);
        this.ghidraTable.getTableHeader().setReorderingAllowed(false);
        this.ghidraTable.setColumnHeaderPopupEnabled(false);
        this.ghidraTable.setBorder(BorderFactory.createEtchedBorder());
        Dimension size = new Dimension(300, 400);
        this.setPreferredSize(size.width, size.height);
        this.setRememberSize(true);
        JPanel buttonPanel = new JPanel();
        buttonPanel.getAccessibleContext().setAccessibleName("Buttons");
        JButton selectAllButton = new JButton("Select All");
        selectAllButton.getAccessibleContext().setAccessibleName("Select All");
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseColumnsDialog.this.setAllSelected(true);
            }
        });
        JButton deselectAllButton = new JButton("Deselect All");
        deselectAllButton.getAccessibleContext().setAccessibleName("Deselect All");
        deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseColumnsDialog.this.setAllSelected(false);
            }
        });
        buttonPanel.add(selectAllButton);
        buttonPanel.add(deselectAllButton);
        JPanel panel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.ghidraTable);
        panel.getAccessibleContext().setAccessibleName("Select Columns");
        scrollPane.getAccessibleContext().setAccessibleName("Scroll");
        panel.add(scrollPane);
        panel.add((Component)buttonPanel, "South");
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation("Tables/GhidraTableHeaders.html", "SelectColumns"));
    }

    private void setAllSelected(boolean selected) {
        Set<TableColumn> keySet = this.selectedMap.keySet();
        for (TableColumn column : keySet) {
            this.selectedMap.put(column, selected);
        }
        this.ghidraTable.repaint();
    }

    private void initialize() {
        List columns = CollectionUtils.asList(this.columnModel.getColumns());
        this.columnList = new ArrayList<TableColumnWrapper>(columns.size());
        for (TableColumn column : columns) {
            boolean visible = this.columnModel.isVisible(column);
            this.selectedMap.put(column, visible);
            if (!visible) continue;
            this.columnList.add(new TableColumnWrapper(this, column));
        }
    }

    boolean isOK() {
        for (Boolean value : this.selectedMap.values()) {
            if (!value.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void okCallback() {
        if (!this.isOK()) {
            this.setStatusText("No Columns selected!");
            return;
        }
        this.close();
    }

    @Override
    protected void cancelCallback() {
        this.wasCancelled = true;
        super.cancelCallback();
    }

    int[] getChosenColumns() {
        if (this.wasCancelled) {
            return null;
        }
        ArrayList<Integer> columnIndices = new ArrayList<Integer>();
        for (TableColumnWrapper columnWrapper : this.columnList) {
            if (!this.selectedMap.get(columnWrapper.getTableColumn()).booleanValue()) continue;
            TableColumn column = columnWrapper.getTableColumn();
            int index = this.columnModel.getColumnIndex(column.getHeaderValue());
            columnIndices.add(index);
        }
        int[] indices = new int[columnIndices.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)columnIndices.get(i);
        }
        return indices;
    }

    private class SelectColumnsModel
    extends DefaultTableModel {
        private SelectColumnsModel() {
        }

        @Override
        public int getRowCount() {
            if (ChooseColumnsDialog.this.columnList == null) {
                return 0;
            }
            return ChooseColumnsDialog.this.columnList.size();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            TableColumnWrapper tableColumnWrapper = ChooseColumnsDialog.this.columnList.get(row);
            TableColumn tableColumn = tableColumnWrapper.getTableColumn();
            if (column == 0) {
                return ChooseColumnsDialog.this.selectedMap.get(tableColumn);
            }
            if (column == 1) {
                return tableColumn.getHeaderValue();
            }
            return "<<unknown>>";
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 0) {
                TableColumnWrapper tableColumnWrapper = ChooseColumnsDialog.this.columnList.get(row);
                ChooseColumnsDialog.this.selectedMap.put(tableColumnWrapper.getTableColumn(), (Boolean)aValue);
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Copy";
            }
            if (column == 1) {
                return "Column Name";
            }
            return "<<unknown>>";
        }
    }

    private class Renderer
    extends GTableCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Object value = data.getValue();
            JTable table = data.getTable();
            int row = data.getRowViewIndex();
            int column = data.getColumnViewIndex();
            boolean isSelected = data.isSelected();
            boolean hasFocus = data.hasFocus();
            JComponent renderer = null;
            if (column == 0) {
                TableCellRenderer booleanRenderer = table.getDefaultRenderer(Boolean.class);
                renderer = (JComponent)booleanRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            } else {
                renderer = (JComponent)super.getTableCellRendererComponent(data);
            }
            if (isSelected) {
                return renderer;
            }
            return renderer;
        }
    }

    private class TableColumnWrapper {
        private final TableColumn column;

        TableColumnWrapper(ChooseColumnsDialog chooseColumnsDialog, TableColumn column) {
            this.column = column;
        }

        public TableColumn getTableColumn() {
            return this.column;
        }
    }
}

