/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.util.ArrayList;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import tim.prune.data.ExtensionInfo;
import tim.prune.data.Field;
import tim.prune.data.FieldGpx;
import tim.prune.data.FieldXml;
import tim.prune.data.FileType;
import tim.prune.load.xml.GpxTag;
import tim.prune.load.xml.XmlHandler;

public class GpxHandler
extends XmlHandler {
    private boolean _insidePoint = false;
    private boolean _insideWaypoint = false;
    private boolean _insideExtensions = false;
    private boolean _startSegment = true;
    private int _trackNum = -1;
    private final GpxTag _fileTitle = new GpxTag();
    private final GpxTag _fileDescription = new GpxTag();
    private final GpxTag _pointName = new GpxTag();
    private final GpxTag _trackName = new GpxTag();
    private final GpxTag _elevation = new GpxTag();
    private final GpxTag _time = new GpxTag();
    private final GpxTag _type = new GpxTag();
    private final GpxTag _description = new GpxTag();
    private final GpxTag _link = new GpxTag();
    private final GpxTag _comment = new GpxTag();
    private final GpxTag _sym = new GpxTag();
    private GpxTag _currentTag = null;
    private final ExtensionInfo _extensionInfo = new ExtensionInfo();
    private final ArrayList<String[]> _pointList = new ArrayList();
    private final ArrayList<String> _linkList = new ArrayList();
    private Stack<String> _extensionTags = null;
    private FieldGpx _gpxField = null;

    public GpxHandler() {
        Field[] fieldArray;
        Field[] fieldArray2 = fieldArray = new Field[]{Field.LATITUDE, Field.LONGITUDE, Field.ALTITUDE, Field.WAYPT_NAME, Field.TIMESTAMP, Field.NEW_SEGMENT, Field.WAYPT_TYPE, Field.DESCRIPTION, Field.COMMENT, Field.SYMBOL};
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            this.addField(field);
            ++n2;
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string3.toLowerCase();
        this._gpxField = null;
        if (string4.equals("wpt") || string4.equals("trkpt") || string4.equals("rtept")) {
            this._insidePoint = true;
            this._insideWaypoint = string4.equals("wpt");
            this.resetCurrentValues();
            this.addCurrentValue(Field.LATITUDE, GpxHandler.getAttribute(attributes, "lat"));
            this.addCurrentValue(Field.LONGITUDE, GpxHandler.getAttribute(attributes, "lon"));
            this._elevation.setValue(null);
            this._pointName.setValue(null);
            this._time.setValue(null);
            this._type.setValue(null);
            this._link.setValue(null);
            this._description.setValue(null);
            this._comment.setValue(null);
            this._sym.setValue(null);
        } else if (string4.equals("ele")) {
            this._currentTag = this._elevation;
        } else if (string4.equals("name")) {
            this._currentTag = this._insidePoint ? this._pointName : (this._trackNum < 0 ? this._fileTitle : this._trackName);
        } else if (string4.equals("time")) {
            this._currentTag = this._time;
        } else if (string4.equals("type")) {
            this._currentTag = this._type;
        } else if (string4.equals("description") || string4.equals("desc")) {
            this._currentTag = this._insidePoint ? this._description : this._fileDescription;
        } else if (string4.equals("cmt")) {
            this._currentTag = this._comment;
        } else if (string4.equals("sym")) {
            this._currentTag = this._sym;
        } else if (string4.equals("link")) {
            this._link.setValue(attributes.getValue("href"));
        } else if (string4.equals("trkseg")) {
            this._startSegment = true;
        } else if (string4.equals("trk")) {
            ++this._trackNum;
            this._trackName.setValue(null);
        } else if (string4.equals("extensions") && this._insidePoint) {
            this._insideExtensions = true;
            this._currentTag = new GpxTag();
            this._extensionTags = new Stack();
        } else if (this._insideExtensions) {
            this._extensionTags.add(string3);
            this._currentTag.clear();
        } else if (string4.equals("gpx")) {
            this.setFileType(FileType.GPX);
            this.processGpxAttributes(attributes);
        } else {
            this._gpxField = FieldGpx.getField(string4);
            this._currentTag = new GpxTag();
        }
        super.startElement(string, string2, string3, attributes);
    }

    private void processGpxAttributes(Attributes attributes) {
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            String string = attributes.getQName(n2).toLowerCase();
            String string2 = attributes.getValue(n2);
            if (string.equals("version")) {
                this.setFileVersion(attributes.getValue(n2));
            } else if (string.contentEquals("xmlns")) {
                this._extensionInfo.setNamespace(string2);
            } else if (string.equals("xmlns:xsi")) {
                this._extensionInfo.setXsi(string2);
            } else if (string.equals("xsi:schemalocation")) {
                object = string2.split(" ");
                int n3 = 0;
                while (n3 < ((String[])object).length) {
                    this._extensionInfo.addXsiAttribute(object[n3]);
                    ++n3;
                }
            } else if (string.startsWith("xmlns:")) {
                object = string.substring(6);
                this._extensionInfo.addNamespace((String)object, string2);
            }
            ++n2;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string3.toLowerCase();
        if (string4.equals("wpt") || string4.equals("trkpt") || string4.equals("rtept")) {
            this.processPoint();
            this._insidePoint = false;
        } else if (string4.equals("extensions")) {
            this._insideExtensions = false;
        } else if (this._insideExtensions) {
            String string5 = this._currentTag.getValue();
            this._extensionTags.pop();
            if (!string5.isEmpty()) {
                FieldXml fieldXml = new FieldXml(FileType.GPX, string4, this._extensionTags);
                if (!this.hasField(fieldXml)) {
                    this.addField(fieldXml);
                }
                this.addCurrentValue(fieldXml, string5);
            }
            this._currentTag.clear();
        } else if (this._gpxField != null) {
            String string6 = this._currentTag.getValue();
            if (!string6.isEmpty()) {
                if (!this.hasField(this._gpxField)) {
                    this.addField(this._gpxField);
                }
                this.addCurrentValue(this._gpxField, string6);
            }
            this._currentTag.clear();
            this._gpxField = null;
        } else if (this._insidePoint && this._currentTag != null && this.getFileVersion().equals("1.0")) {
            String string7;
            String string8 = this._currentTag.getValue();
            String string9 = GpxHandler.getNamespace(string4);
            if (string9 != null && !string8.isEmpty() && (string7 = this.getExtensionInfo().getNamespaceName(string9)) != null) {
                FieldXml fieldXml = new FieldXml(FileType.GPX, string4, string7);
                if (!this.hasField(fieldXml)) {
                    this.addField(fieldXml);
                }
                this.addCurrentValue(fieldXml, string8);
            }
            this._currentTag = null;
        } else {
            this._currentTag = null;
        }
        super.endElement(string, string2, string3);
    }

    private static String getNamespace(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this._currentTag != null) {
            this._currentTag.setValue(GpxHandler.checkCharacters(this._currentTag.getValue(), string));
        }
        super.characters(cArray, n, n2);
    }

    private static String checkCharacters(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return String.valueOf(string) + string2;
    }

    private void processPoint() {
        this.addCurrentValue(Field.ALTITUDE, this._elevation.getValue());
        if (this._insideWaypoint) {
            this.addCurrentValue(Field.WAYPT_NAME, this._pointName.getValue());
        }
        this.addCurrentValue(Field.TIMESTAMP, this._time.getValue());
        if (this._startSegment && !this._insideWaypoint) {
            this.addCurrentValue(Field.NEW_SEGMENT, "1");
            this._startSegment = false;
        }
        this.addCurrentValue(Field.WAYPT_TYPE, this._type.getValue());
        this.addCurrentValue(Field.DESCRIPTION, this._description.getValue());
        this.addCurrentValue(Field.COMMENT, this._comment.getValue());
        this.addCurrentValue(Field.SYMBOL, this._sym.getValue());
        this._pointList.add(this.getCurrentValues());
        this._linkList.add(this._link.getValue());
    }

    @Override
    public String[][] getDataArray() {
        int n = this._pointList.size();
        String[][] stringArray = new String[n][];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._pointList.get(n2);
            ++n2;
        }
        return stringArray;
    }

    @Override
    public String[] getLinkArray() {
        int n = this._linkList.size();
        boolean bl = false;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._linkList.get(n2);
            if (stringArray[n2] != null) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            stringArray = null;
        }
        return stringArray;
    }

    @Override
    public String getFileTitle() {
        return this._fileTitle.getValue();
    }

    @Override
    public String getFileDescription() {
        return this._fileDescription.getValue();
    }

    @Override
    public ExtensionInfo getExtensionInfo() {
        return this._extensionInfo;
    }
}

