/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.json.JsonDecodingException;
import kotlinx.serialization.json.JsonEncodingException;
import kotlinx.serialization.json.JsonException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a8\u0006\u000f"}, d2={"InvalidFloatingPoint", "Lkotlinx/serialization/json/JsonEncodingException;", "value", "", "type", "", "key", "JsonMapInvalidKeyKind", "Lkotlinx/serialization/json/JsonException;", "keyDescriptor", "Lkotlinx/serialization/SerialDescriptor;", "jsonUnknownKeyException", "Lkotlinx/serialization/json/JsonDecodingException;", "position", "", "kotlinx-serialization-runtime"})
public final class JsonExceptionHelpersKt {
    @NotNull
    public static final JsonEncodingException InvalidFloatingPoint(@NotNull Number value, @NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return new JsonEncodingException(value + " is not a valid " + type + " as per JSON specification. " + "You can disable strict mode to serialize such values");
    }

    @NotNull
    public static final JsonEncodingException InvalidFloatingPoint(@NotNull Number value, @NotNull String key, @NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return new JsonEncodingException(value + " with key " + key + " is not a valid " + type + " as per JSON specification. " + "You can disable strict mode to serialize such values");
    }

    @NotNull
    public static final JsonDecodingException jsonUnknownKeyException(int position, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return new JsonDecodingException(position, "Strict JSON encountered unknown key: " + key + '\n' + "You can disable strict mode to skip unknown keys");
    }

    @NotNull
    public static final JsonException JsonMapInvalidKeyKind(@NotNull SerialDescriptor keyDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)keyDescriptor, (String)"keyDescriptor");
        return new JsonException("Value of type " + keyDescriptor.getName() + " can't be used in json as map key. " + "It should have either primitive or enum kind, but its kind is " + keyDescriptor.getKind() + ".\n" + "You can convert such maps to arrays [key1, value1, key2, value2,...] with 'allowStructuredMapKeys' flag in JsonConfiguration.");
    }
}

