/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInsight.completion.BaseCompletionLookupArranger;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchResult;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;

public final class MavenDependencyCompletionUtil {
    public static boolean isPlugin(@NotNull MavenDomShortArtifactCoordinates dependency) {
        if (dependency == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(0);
        }
        return dependency instanceof MavenDomPlugin;
    }

    public static MavenDomPlugin findManagedPlugin(MavenDomProjectModel domModel, Project project, @NotNull String groupId, @NotNull String artifactId) {
        if (groupId == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(1);
        }
        if (artifactId == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(2);
        }
        Ref ref = new Ref();
        MavenDomProjectProcessorUtils.processPluginsInPluginManagement(domModel, (Processor<? super MavenDomPlugin>)((Processor)plugin -> {
            if (groupId.equals(plugin.getGroupId().getStringValue()) && artifactId.equals(plugin.getArtifactId().getStringValue()) && null != plugin.getVersion().getStringValue()) {
                ref.set(plugin);
                return true;
            }
            return false;
        }), project);
        return (MavenDomPlugin)ref.get();
    }

    public static MavenDomDependency findManagedDependency(MavenDomProjectModel domModel, Project project, @NotNull String groupId, @NotNull String artifactId) {
        if (groupId == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(3);
        }
        if (artifactId == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(4);
        }
        Ref ref = new Ref();
        MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(domModel, (Processor<? super MavenDomDependency>)((Processor)dependency -> {
            if (groupId.equals(dependency.getGroupId().getStringValue()) && artifactId.equals(dependency.getArtifactId().getStringValue())) {
                ref.set(dependency);
                return true;
            }
            return false;
        }), project);
        return (MavenDomDependency)ref.get();
    }

    public static boolean isInsideManagedDependency(@NotNull MavenDomShortArtifactCoordinates dependency) {
        DomElement parent;
        if (dependency == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(5);
        }
        if (!((parent = dependency.getParent()) instanceof MavenDomDependencies)) {
            return false;
        }
        return parent.getParent() instanceof MavenDomDependencyManagement;
    }

    public static void invokeCompletion(@NotNull InsertionContext context2, CompletionType completionType) {
        if (context2 == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(6);
        }
        context2.setLaterRunnable(() -> new CodeCompletionHandlerBase(completionType).invokeCompletion(context2.getProject(), context2.getEditor()));
    }

    public static LookupElementBuilder lookupElement(MavenDependencyCompletionItem item, String lookup) {
        return LookupElementBuilder.create((Object)item, (String)lookup).withIcon(MavenDependencyCompletionUtil.getIcon(item.getType()));
    }

    public static MavenDependencyCompletionItem getMaxIcon(MavenArtifactSearchResult searchResult) {
        return Collections.max(Arrays.asList(searchResult.getSearchResults().getItems()), Comparator.comparing(r -> {
            if (r.getType() == null) {
                return Integer.MIN_VALUE;
            }
            return r.getType().getWeight();
        }));
    }

    public static LookupElementBuilder lookupElement(MavenRepositoryArtifactInfo info) {
        return MavenDependencyCompletionUtil.lookupElement(info, MavenDependencyCompletionUtil.getPresentableText(info));
    }

    public static LookupElementBuilder lookupElement(MavenRepositoryArtifactInfo info, String presentableText) {
        LookupElementBuilder elementBuilder = LookupElementBuilder.create((Object)info, (String)MavenDependencyCompletionUtil.getLookupString(info)).withPresentableText(presentableText);
        elementBuilder.putUserData(BaseCompletionLookupArranger.FORCE_MIDDLE_MATCH, new Object());
        if (info.getItems().length == 1) {
            return elementBuilder.withIcon(MavenDependencyCompletionUtil.getIcon(info.getItems()[0].getType()));
        }
        return elementBuilder;
    }

    public static String getPresentableText(MavenRepositoryArtifactInfo info) {
        if (info.getItems().length == 1) {
            return MavenDependencyCompletionUtil.getLookupString(info.getItems()[0]);
        }
        return IndicesBundle.message("maven.dependency.completion.presentable", info.getGroupId(), info.getArtifactId());
    }

    @Nullable
    public static Icon getIcon(@Nullable MavenDependencyCompletionItem.Type type) {
        if (type == MavenDependencyCompletionItem.Type.PROJECT) {
            return AllIcons.Nodes.Module;
        }
        return null;
    }

    public static String getLookupString(MavenRepositoryArtifactInfo info) {
        MavenDependencyCompletionItem[] infoItems = info.getItems();
        if (infoItems.length > 0) {
            return MavenDependencyCompletionUtil.getLookupString(infoItems[0]);
        }
        return info.getGroupId() + ":" + info.getArtifactId();
    }

    public static String getLookupString(MavenDependencyCompletionItem description) {
        StringBuilder builder2 = new StringBuilder(description.getGroupId());
        if (description.getArtifactId() == null) {
            builder2.append(":...");
        } else {
            builder2.append(":").append(description.getArtifactId());
            if (description.getPackaging() != null) {
                builder2.append(":").append(description.getPackaging());
            }
            if (description.getVersion() != null) {
                builder2.append(":").append(description.getVersion());
            } else {
                builder2.append(":...");
            }
        }
        return builder2.toString();
    }

    @NotNull
    public static String removeDummy(@Nullable String str) {
        if (str == null) {
            return "";
        }
        String string = StringUtil.trim((String)str.replace("IntellijIdeaRulezzz ", "").replace(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED, ""));
        if (string == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/converters/MavenDependencyCompletionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/converters/MavenDependencyCompletionUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDummy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPlugin";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findManagedPlugin";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findManagedDependency";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInsideManagedDependency";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeCompletion";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

