/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.Paths;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class DifferenceReverter
extends Reverter {
    private final List<Difference> myDiffs;

    public DifferenceReverter(Project p, LocalHistoryFacade vcs, IdeaGateway gw, List<Difference> diffs, @NotNull Supplier<@NlsContexts.Command String> commandName) {
        if (commandName == null) {
            DifferenceReverter.$$$reportNull$$$0(0);
        }
        super(p, vcs, gw, commandName);
        this.myDiffs = diffs;
    }

    public DifferenceReverter(Project p, LocalHistoryFacade vcs, IdeaGateway gw, List<Difference> diffs, Revision leftRevision) {
        this(p, vcs, gw, diffs, () -> DifferenceReverter.getRevertCommandName(leftRevision));
    }

    @Override
    @NotNull
    protected List<VirtualFile> getFilesToClearROStatus() {
        LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
        for (Difference each : this.myDiffs) {
            VirtualFile f;
            Entry l = each.getLeft();
            Entry r = each.getRight();
            VirtualFile virtualFile = f = l == null ? null : this.myGateway.findVirtualFile(l.getPath());
            if (f != null) {
                files.add(f);
            }
            if ((f = r == null ? null : this.myGateway.findVirtualFile(r.getPath())) == null) continue;
            files.add(f);
        }
        return new ArrayList<VirtualFile>(files);
    }

    @Override
    protected void doRevert() throws IOException {
        this.doRevert(true);
    }

    public void doRevert(boolean revertContentChanges) throws IOException {
        HashSet<String> vetoedFiles = new HashSet<String>();
        for (Difference each : ContainerUtil.iterateBackward(this.myDiffs)) {
            Entry l = each.getLeft();
            Entry r = each.getRight();
            if (l == null) {
                this.revertCreation(r, vetoedFiles);
                continue;
            }
            vetoedFiles.add(l.getPath());
            if (r == null) {
                this.revertDeletion(l);
                continue;
            }
            VirtualFile file = this.myGateway.findOrCreateFileSafely(r.getPath(), r.isDirectory());
            this.revertRename(l, file);
            if (!revertContentChanges) continue;
            DifferenceReverter.revertContentChange(l, file);
        }
    }

    private void revertCreation(@NotNull Entry r, @NotNull Set<String> vetoedFiles) throws IOException {
        if (r == null) {
            DifferenceReverter.$$$reportNull$$$0(1);
        }
        if (vetoedFiles == null) {
            DifferenceReverter.$$$reportNull$$$0(2);
        }
        String path = r.getPath();
        for (String each : vetoedFiles) {
            if (!Paths.isParent(path, each)) continue;
            return;
        }
        VirtualFile f = this.myGateway.findVirtualFile(path);
        if (f != null) {
            f.delete((Object)this);
        }
    }

    private void revertDeletion(@NotNull Entry l) throws IOException {
        if (l == null) {
            DifferenceReverter.$$$reportNull$$$0(3);
        }
        VirtualFile f = this.myGateway.findOrCreateFileSafely(l.getPath(), l.isDirectory());
        if (l.isDirectory()) {
            return;
        }
        DifferenceReverter.setContent(l, f);
    }

    private void revertRename(@NotNull Entry l, @NotNull VirtualFile file) throws IOException {
        String oldName;
        if (l == null) {
            DifferenceReverter.$$$reportNull$$$0(4);
        }
        if (file == null) {
            DifferenceReverter.$$$reportNull$$$0(5);
        }
        if (!(oldName = l.getName()).equals(file.getName())) {
            VirtualFile existing = file.getParent().findChild(oldName);
            if (existing != null) {
                existing.delete((Object)this);
            }
            file.rename((Object)this, oldName);
        }
    }

    private static void revertContentChange(@NotNull Entry l, VirtualFile file) throws IOException {
        if (l == null) {
            DifferenceReverter.$$$reportNull$$$0(6);
        }
        if (l.isDirectory()) {
            return;
        }
        if (file.getTimeStamp() != l.getTimestamp()) {
            DifferenceReverter.setContent(l, file);
        }
    }

    private static void setContent(@NotNull Entry l, VirtualFile file) throws IOException {
        Content c;
        if (l == null) {
            DifferenceReverter.$$$reportNull$$$0(7);
        }
        if (!(c = l.getContent()).isAvailable()) {
            return;
        }
        file.setBinaryContent(c.getBytes());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vetoedFiles";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/history/integration/revertion/DifferenceReverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "revertCreation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "revertDeletion";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "revertRename";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "revertContentChange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

