/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.assignment.plugin.k2.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.assignment.plugin.k2.FirAssignAnnotationMatchingServiceKt;
import org.jetbrains.kotlin.assignment.plugin.k2.diagnostics.FirErrorsAssignmentPlugin;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeDiagnosticWithSingleCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u0002H\u0002J\u001c\u0010\u000f\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0015\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u0016\u001a\u00020\u000e*\u00020\u0002H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/assignment/plugin/k2/diagnostics/FirAssignmentPluginFunctionCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isOverloadAssignCallCandidate", "", "isOverloadedAssignCallError", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "isOverloadedAssignCall", "isAnnotated", "isReturnTypeUnit", "kotlin-assignment-compiler-plugin.k2"})
@SourceDebugExtension(value={"SMAP\nFirAssignmentPluginFunctionCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAssignmentPluginFunctionCallChecker.kt\norg/jetbrains/kotlin/assignment/plugin/k2/diagnostics/FirAssignmentPluginFunctionCallChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,67:1\n43#2:68\n*S KotlinDebug\n*F\n+ 1 FirAssignmentPluginFunctionCallChecker.kt\norg/jetbrains/kotlin/assignment/plugin/k2/diagnostics/FirAssignmentPluginFunctionCallChecker\n*L\n47#1:68\n*E\n"})
public final class FirAssignmentPluginFunctionCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirAssignmentPluginFunctionCallChecker INSTANCE = new FirAssignmentPluginFunctionCallChecker();

    private FirAssignmentPluginFunctionCallChecker() {
        super(MppCheckerKind.Common);
    }

    public void check(@NotNull FirFunctionCall expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!this.isOverloadAssignCallCandidate(expression)) {
            return;
        }
        FirNamedReference calleeReference = expression.getCalleeReference();
        if (FirReferenceUtilsKt.isError((FirReference)((FirReference)calleeReference))) {
            if (this.isOverloadedAssignCallError(expression, context.getSession(), ((FirDiagnosticHolder)calleeReference).getDiagnostic())) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirErrorsAssignmentPlugin.INSTANCE.getNO_APPLICABLE_ASSIGN_METHOD(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
        } else if (this.isOverloadedAssignCall(expression, context.getSession()) && !this.isReturnTypeUnit(expression)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirErrorsAssignmentPlugin.INSTANCE.getCALL_ERROR_ASSIGN_METHOD_SHOULD_RETURN_UNIT(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isOverloadAssignCallCandidate(FirFunctionCall $this$isOverloadAssignCallCandidate) {
        FirCall $this$arguments$iv = (FirCall)$this$isOverloadAssignCallCandidate;
        boolean $i$f$getArguments = false;
        if ($this$arguments$iv.getArgumentList().getArguments().size() != 1) return false;
        KtSourceElement ktSourceElement = $this$isOverloadAssignCallCandidate.getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.AssignmentPluginAltered.INSTANCE)) return false;
        return true;
    }

    private final boolean isOverloadedAssignCallError(FirFunctionCall $this$isOverloadedAssignCallError, FirSession session, ConeDiagnostic diagnostic) {
        ConeDiagnostic coneDiagnostic = diagnostic;
        Name functionName = coneDiagnostic instanceof ConeAmbiguityError ? ((ConeAmbiguityError)diagnostic).getName() : (coneDiagnostic instanceof ConeDiagnosticWithSingleCandidate ? ((ConeDiagnosticWithSingleCandidate)diagnostic).getCandidate().getCallInfo().getName() : (coneDiagnostic instanceof ConeUnresolvedNameError ? ((ConeUnresolvedNameError)diagnostic).getName() : $this$isOverloadedAssignCallError.getCalleeReference().getName()));
        return Intrinsics.areEqual((Object)functionName, (Object)OperatorConventions.ASSIGN_METHOD) && this.isAnnotated($this$isOverloadedAssignCallError, session);
    }

    private final boolean isOverloadedAssignCall(FirFunctionCall $this$isOverloadedAssignCall, FirSession session) {
        return Intrinsics.areEqual((Object)$this$isOverloadedAssignCall.getCalleeReference().getName(), (Object)OperatorConventions.ASSIGN_METHOD) && this.isAnnotated($this$isOverloadedAssignCall, session);
    }

    private final boolean isAnnotated(FirFunctionCall $this$isAnnotated, FirSession session) {
        FirExpression firExpression;
        return FirAssignAnnotationMatchingServiceKt.getAnnotationMatchingService(session).isAnnotated((firExpression = $this$isAnnotated.getExplicitReceiver()) != null && (firExpression = FirTypeUtilsKt.getResolvedType((FirExpression)firExpression)) != null ? ToSymbolUtilsKt.toRegularClassSymbol((ConeKotlinType)firExpression, (FirSession)session) : null);
    }

    private final boolean isReturnTypeUnit(FirFunctionCall $this$isReturnTypeUnit) {
        FirCallableSymbol firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol((FirResolvable)((FirResolvable)$this$isReturnTypeUnit));
        return firCallableSymbol != null && (firCallableSymbol = firCallableSymbol.getResolvedReturnType()) != null ? ConeBuiltinTypeUtilsKt.isUnit((ConeKotlinType)firCallableSymbol) : false;
    }
}

