/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.performancePlugin.commands.GoToPsiElementKt;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/performancePlugin/commands/GoToNamedElementCommand;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "hasCommentParent", "", "root", "Lcom/intellij/psi/PsiElement;", "element", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nGoToNamedElementCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoToNamedElementCommand.kt\ncom/jetbrains/performancePlugin/commands/GoToNamedElementCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,72:1\n739#2,9:73\n37#3:82\n36#3,3:83\n*S KotlinDebug\n*F\n+ 1 GoToNamedElementCommand.kt\ncom/jetbrains/performancePlugin/commands/GoToNamedElementCommand\n*L\n31#1:73,9\n31#1:82\n31#1:83,3\n*E\n"})
public final class GoToNamedElementCommand
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%goToNamedPsiElement";
    @NotNull
    public static final String SUPPRESS_ERROR_IF_NOT_FOUND = "SUPPRESS_ERROR_IF_NOT_FOUND";
    @NotNull
    private static final Regex REGEX = new Regex(" ");
    @NotNull
    private static final Set<String> COMMENTS_NAMES;

    public GoToNamedElementCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallback actionCallback = new ActionCallbackProfilerStopper();
        String input = this.extractCommandArgument(PREFIX);
        Intrinsics.checkNotNull((Object)input);
        Object object = input;
        Regex regex = REGEX;
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] params = thisCollection$iv.toArray(new String[0]);
        String position = params[0];
        String elementName = params[1];
        ApplicationManager.getApplication().invokeLater(() -> GoToNamedElementCommand._execute$lambda$3(context, actionCallback, position, params, elementName, this));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private final boolean hasCommentParent(PsiElement root, PsiElement element) {
        PsiElement current = element;
        while (!Intrinsics.areEqual((Object)current, (Object)root)) {
            IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)current);
            if (CollectionsKt.contains((Iterable)COMMENTS_NAMES, (Object)(iElementType != null ? iElementType.getDebugName() : null)) || COMMENTS_NAMES.contains(String.valueOf(PsiTreeUtilKt.getElementType((PsiElement)current))) || COMMENTS_NAMES.contains(current.getNode().getElementType().toString())) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)current.getParent(), (String)"getParent(...)");
        }
        return false;
    }

    private static final void _execute$lambda$3$lambda$1(Editor $editor, CaretListener $caretListener) {
        $editor.getCaretModel().removeCaretListener($caretListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean _execute$lambda$3$lambda$2(String $elementName, GoToNamedElementCommand this$0, PsiFile $psiFile, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)$elementName, (Object)it.getText())) return false;
        PsiFile psiFile = $psiFile;
        Intrinsics.checkNotNull((Object)psiFile);
        if (this$0.hasCommentParent((PsiElement)psiFile, it)) return false;
        return true;
    }

    private static final void _execute$lambda$3(PlaybackContext $context, ActionCallback $actionCallback, String $position, String[] $params, String $elementName, GoToNamedElementCommand this$0) {
        Editor editor = FileEditorManager.getInstance((Project)$context.getProject()).getSelectedTextEditor();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)$context.getProject());
        Editor editor2 = editor;
        Intrinsics.checkNotNull((Object)editor2);
        PsiFile psiFile = psiDocumentManager.getPsiFile(editor2.getDocument());
        CaretListener caretListener2 = new CaretListener($actionCallback){
            final /* synthetic */ ActionCallback $actionCallback;
            {
                this.$actionCallback = $actionCallback;
            }

            public void caretPositionChanged(CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$actionCallback.setDone();
            }
        };
        editor.getCaretModel().addCaretListener(caretListener2);
        $actionCallback.doWhenProcessed(() -> GoToNamedElementCommand._execute$lambda$3$lambda$1(editor, caretListener2));
        GoToPsiElementKt.goToElement((PsiElement)psiFile, $position, $actionCallback, editor, (Function1<? super PsiElement, Boolean>)((Function1)arg_0 -> GoToNamedElementCommand._execute$lambda$3$lambda$2($elementName, this$0, psiFile, arg_0)));
        if (ArraysKt.contains((Object[])$params, (Object)SUPPRESS_ERROR_IF_NOT_FOUND) && !$actionCallback.isDone()) {
            $actionCallback.setDone();
        } else if (!$actionCallback.isDone()) {
            String string = Arrays.toString($params);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            $actionCallback.reject("not found element " + string);
        }
    }

    static {
        Object[] objectArray = new String[]{"KDoc", "BLOCK_COMMENT", "EOL_COMMENT", "SHEBANG_COMMENT", "DOC_COMMENT", "END_OF_LINE_COMMENT", "C_STYLE_COMMENT"};
        COMMENTS_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/performancePlugin/commands/GoToNamedElementCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "SUPPRESS_ERROR_IF_NOT_FOUND", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;", "COMMENTS_NAMES", "", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

