/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.task;

import org.jsampler.CC;
import org.jsampler.JSI18n;
import org.jsampler.SamplerModel;
import org.jsampler.task.EnhancedTask;
import org.linuxsampler.lscp.Instrument;
import org.linuxsampler.lscp.SamplerEngine;
import org.linuxsampler.lscp.ServerInfo;

public class Global {
    private Global() {
    }

    public static class DummyTask
    extends EnhancedTask {
        @Override
        public void run() {
        }
    }

    public static class GetFileInstrument
    extends EnhancedTask<Instrument> {
        private final String filename;
        private final int instrIdx;

        public GetFileInstrument(String string, int n) {
            this.setSilent(true);
            this.filename = string;
            this.instrIdx = n;
            this.setTitle("Global.GetFileInstrument_task");
            this.setDescription(JSI18n.i18n.getMessage("Global.GetFileInstrument.desc"));
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getFileInstrumentInfo(this.filename, this.instrIdx));
        }
    }

    public static class GetFileInstruments
    extends EnhancedTask<Instrument[]> {
        private final String filename;

        public GetFileInstruments(String string) {
            this.setSilent(true);
            this.filename = string;
            this.setTitle("Global.GetFileInstruments_task");
            this.setDescription(JSI18n.i18n.getMessage("Global.GetFileInstruments.desc"));
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getFileInstruments(this.filename));
        }
    }

    public static class SetClientReadTimeout
    extends EnhancedTask {
        private int timeout;

        public SetClientReadTimeout(int n) {
            this.setTitle("Global.SetClientReadTimeout_task");
            this.setDescription(JSI18n.i18n.getMessage("Global.SetClientReadTimeout.desc"));
            this.timeout = n;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setSoTimeout(this.timeout * 1000);
        }
    }

    public static class UpdateTotalVoiceCount
    extends EnhancedTask {
        public UpdateTotalVoiceCount() {
            this.setSilent(true);
            this.setTitle("Global.UpdateTotalVoiceCount_task");
            this.setDescription(JSI18n.i18n.getMessage("Global.UpdateTotalVoiceCount.desc"));
        }

        @Override
        public void exec() throws Exception {
            SamplerModel samplerModel = CC.getSamplerModel();
            int n = CC.getClient().getTotalVoiceCount();
            int n2 = CC.getClient().getTotalVoiceCountMax();
            samplerModel.updateActiveVoiceInfo(n, n2);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            return object instanceof UpdateTotalVoiceCount;
        }
    }

    public static class SetPolyphony
    extends EnhancedTask {
        private int maxVoices;
        private int maxStreams;

        public SetPolyphony(int n, int n2) {
            this.setTitle("Global.SetPolyphony_task");
            this.setDescription(JSI18n.i18n.getMessage("Global.SetPolyphony.desc"));
            this.maxVoices = n;
            this.maxStreams = n2;
        }

        @Override
        public void exec() throws Exception {
            if (this.maxVoices != -1) {
                CC.getClient().setGlobalVoiceLimit(this.maxVoices);
            }
            if (this.maxStreams != -1) {
                CC.getClient().setGlobalStreamLimit(this.maxStreams);
            }
        }
    }

    public static class SetVolume
    extends EnhancedTask {
        private float volume;

        public SetVolume(float f) {
            this.setTitle("Global.SetVolume_task");
            this.setDescription(JSI18n.i18n.getMessage("Global.SetVolume.desc"));
            this.volume = f;
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().setVolume(this.volume);
        }
    }

    public static class GetVolume
    extends EnhancedTask<Float> {
        public GetVolume() {
            this.setTitle("Global.GetVolume_task");
            this.setDescription(JSI18n.i18n.getMessage("Global.GetVolume.desc"));
        }

        @Override
        public void exec() throws Exception {
            this.setResult(Float.valueOf(CC.getClient().getVolume()));
        }
    }

    public static class GetEngines
    extends EnhancedTask<SamplerEngine[]> {
        public GetEngines() {
            this.setTitle("Global.GetEngines_task");
            this.setDescription(JSI18n.i18n.getMessage("Global.GetEngines.desc"));
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getEngines());
        }
    }

    public static class ResetSampler
    extends EnhancedTask {
        public ResetSampler() {
            this.setTitle("Global.ResetSampler_task");
            this.setDescription(JSI18n.i18n.getMessage("Global.ResetSampler.desc"));
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().resetSampler();
        }
    }

    public static class GetServerInfo
    extends EnhancedTask<ServerInfo> {
        public GetServerInfo() {
            this.setTitle("Global.GetServerInfo_task");
            this.setDescription(JSI18n.i18n.getMessage("Global.GetServerInfo.desc"));
        }

        @Override
        public void exec() throws Exception {
            this.setResult(CC.getClient().getServerInfo());
        }
    }

    public static class Disconnect
    extends EnhancedTask {
        public Disconnect() {
            this.setSilent(true);
            this.setTitle("Global.Disconnect_task");
            this.setDescription("Disconnecting...");
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().disconnect();
            if (CC.getMainFrame().getLSConsoleModel() != null) {
                CC.getMainFrame().getLSConsoleModel().quit();
            }
        }
    }

    public static class Connect
    extends EnhancedTask {
        public Connect() {
            this.setTitle("Global.Connect_task");
            this.setDescription(JSI18n.i18n.getMessage("Global.Connect.desc"));
        }

        @Override
        public void exec() throws Exception {
            CC.getClient().connect();
        }
    }
}

