/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.spi;

import java.util.Map;
import java.util.ServiceLoader;
import oracle.jdbc.spi.OracleConfigurationSecretProvider;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonObject;

public interface OracleConfigurationJsonSecretProvider
extends OracleConfigurationSecretProvider {
    public char[] getSecret(OracleJsonObject var1);

    @Override
    default public char[] getSecret(Map<String, String> secretProperties) {
        String method;
        OracleJsonFactory jsonFactory = new OracleJsonFactory();
        OracleJsonObject secretJsonObject = jsonFactory.createObject();
        String value = secretProperties.remove("value");
        if (value != null) {
            secretJsonObject.put("value", value);
        }
        if ((method = secretProperties.remove("authentication")) != null) {
            OracleJsonObject authJsonObject = jsonFactory.createObject();
            authJsonObject.put("method", method);
            secretProperties.forEach(authJsonObject::put);
            secretJsonObject.put("authentication", authJsonObject);
        }
        return this.getSecret(secretJsonObject);
    }

    public static OracleConfigurationJsonSecretProvider find(String secretType) {
        for (OracleConfigurationJsonSecretProvider provider : ServiceLoader.load(OracleConfigurationJsonSecretProvider.class)) {
            if (!provider.getSecretType().equals(secretType)) continue;
            return provider;
        }
        throw new IllegalStateException("Cannot find the provider type: " + secretType);
    }
}

