/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.iot;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.iot.MqttRequestResponse;
import software.amazon.awssdk.crt.iot.MqttRequestResponseClientOptions;
import software.amazon.awssdk.crt.iot.RequestResponseOperation;
import software.amazon.awssdk.crt.iot.StreamingOperation;
import software.amazon.awssdk.crt.iot.StreamingOperationOptions;
import software.amazon.awssdk.crt.mqtt.MqttClientConnection;
import software.amazon.awssdk.crt.mqtt5.Mqtt5Client;

public class MqttRequestResponseClient
extends CrtResource {
    private final ReentrantReadWriteLock handleLock = new ReentrantReadWriteLock();
    private final Lock handleReadLock = this.handleLock.readLock();
    private final Lock handleWriteLock = this.handleLock.writeLock();

    public MqttRequestResponseClient(Mqtt5Client client, MqttRequestResponseClientOptions options) {
        this.acquireNativeHandle(MqttRequestResponseClient.mqttRequestResponseClientNewFrom5(this, client.getNativeHandle(), options.getMaxRequestResponseSubscriptions(), options.getMaxStreamingSubscriptions(), options.getOperationTimeoutSeconds()));
    }

    public MqttRequestResponseClient(MqttClientConnection client, MqttRequestResponseClientOptions options) {
        this.acquireNativeHandle(MqttRequestResponseClient.mqttRequestResponseClientNewFrom311(this, client.getNativeHandle(), options.getMaxRequestResponseSubscriptions(), options.getMaxStreamingSubscriptions(), options.getOperationTimeoutSeconds()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<MqttRequestResponse> submitRequest(RequestResponseOperation request) {
        CompletableFuture<MqttRequestResponse> future = new CompletableFuture<MqttRequestResponse>();
        this.handleReadLock.lock();
        try {
            long handle = this.getNativeHandle();
            if (handle != 0L) {
                MqttRequestResponseClient.mqttRequestResponseClientSubmitRequest(this.getNativeHandle(), request, future);
            } else {
                future.completeExceptionally(new CrtRuntimeException("Client already closed"));
            }
        }
        finally {
            this.handleReadLock.unlock();
        }
        return future;
    }

    public StreamingOperation createStream(StreamingOperationOptions options) {
        this.handleReadLock.lock();
        try {
            long handle = this.getNativeHandle();
            if (handle != 0L) {
                StreamingOperation streamingOperation = new StreamingOperation(this, options);
                return streamingOperation;
            }
            throw new CrtRuntimeException("Client already closed");
        }
        finally {
            this.handleReadLock.unlock();
        }
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            MqttRequestResponseClient.mqttRequestResponseClientDestroy(this.getNativeHandle());
        }
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    public void close() {
        this.handleWriteLock.lock();
        try {
            super.close();
        }
        finally {
            this.handleWriteLock.unlock();
        }
    }

    private static native long mqttRequestResponseClientNewFrom5(MqttRequestResponseClient var0, long var1, int var3, int var4, int var5) throws CrtRuntimeException;

    private static native long mqttRequestResponseClientNewFrom311(MqttRequestResponseClient var0, long var1, int var3, int var4, int var5) throws CrtRuntimeException;

    private static native void mqttRequestResponseClientDestroy(long var0);

    private static native void mqttRequestResponseClientSubmitRequest(long var0, RequestResponseOperation var2, CompletableFuture<MqttRequestResponse> var3);
}

