/**
 * ./src/components/information.tsx
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import React from 'react';
import Settings from '../../classes/settings.js';
import Pacman from '../../classes/pacman.js';
import Utils from '../../classes/utils.js';
import Title from './title.js';
import { render, Text, Box } from 'ink';
export default async function information(verbose = false) {
    const echo = Utils.setEcho(verbose);
    console.clear();
    const settings = new Settings();
    settings.load();
    const Wait = () => (React.createElement(Box, { marginRight: 2 },
        React.createElement(Box, { marginRight: 2 },
            React.createElement(Text, null, " E G G S: the reproductive system of penguins"))));
    render(React.createElement(Wait, null));
    const Nest = () => (React.createElement(Box, { borderStyle: "round", marginRight: 2 },
        React.createElement(Box, { marginRight: 2 },
            React.createElement(Text, null,
                "nest: ",
                React.createElement(Text, { color: "cyan" }, settings.config.snapshot_dir))),
        React.createElement(Box, { marginRight: 2 },
            React.createElement(Text, null,
                "name: ",
                React.createElement(Text, { color: "cyan" },
                    settings.config.snapshot_prefix,
                    settings.config.snapshot_basename)))));
    const Boot = () => (React.createElement(Box, { borderStyle: "round", marginRight: 2 },
        React.createElement(Box, { marginRight: 2 },
            React.createElement(Text, null,
                "kernel: ",
                React.createElement(Text, { color: "cyan" }, settings.kernel_image))),
        React.createElement(Box, { marginRight: 2 },
            React.createElement(Text, null,
                "initrd.img: ",
                React.createElement(Text, { color: "cyan" }, settings.initrd_image)))));
    const Live = () => (React.createElement(Box, { borderStyle: "round", marginRight: 2 },
        React.createElement(Box, { marginRight: 2 },
            React.createElement(Text, null,
                "live user/passwd: ",
                React.createElement(Text, { color: "cyan" },
                    settings.config.user_opt,
                    "/",
                    settings.config.user_opt_passwd))),
        React.createElement(Box, { marginRight: 2 },
            React.createElement(Text, null,
                "root passwd: ",
                React.createElement(Text, { color: "cyan" }, settings.config.root_passwd)))));
    /**
     * getOsRelease
     */
    const osInfo = Utils.getOsRelease();
    const codenameId = osInfo.VERSION_CODENAME;
    const releaseId = osInfo.VERSION_ID;
    const distroId = osInfo.ID;
    const Distro = () => (React.createElement(Box, { flexDirection: 'column' },
        React.createElement(Box, { borderStyle: "round", marginRight: 2, flexDirection: 'row' },
            React.createElement(Box, { marginRight: 2 },
                React.createElement(Text, null,
                    "distro: ",
                    React.createElement(Text, { color: "cyan" },
                        distroId,
                        " ",
                        releaseId,
                        " ",
                        codenameId))),
            React.createElement(Box, { marginRight: 2 },
                React.createElement(Text, null,
                    "compatible: ",
                    React.createElement(Text, { color: "cyan" },
                        settings.distro.distroLike,
                        " ",
                        settings.distro.distroUniqueId))))));
    const configurations = Pacman.configurationCheck();
    let uefi = Pacman.isUefi();
    let installer = false;
    if (Pacman.isInstalledGui()) {
        installer = Pacman.calamaresExists();
    }
    const Ok = () => (React.createElement(Text, { backgroundColor: "green" }, "OK"));
    const Ko = () => (React.createElement(Text, { backgroundColor: "red", color: "white" }, "KO"));
    const CLI = () => (React.createElement(Text, { color: "cyan" }, "krill"));
    const GUI = () => (React.createElement(Text, { color: "cyan" }, "calamares"));
    const Host = () => (React.createElement(Text, { color: "cyan" }, "host"));
    const Container = () => (React.createElement(Text, { color: "cyan" }, "container"));
    let initType = '';
    if (Utils.isSystemd()) {
        initType = 'systemd';
    }
    else if (Utils.isOpenRc()) {
        initType = 'openrc';
    }
    else if (Utils.isSysvinit()) {
        initType = 'sysvinit';
    }
    const RunningOn = () => (React.createElement(Box, { borderStyle: "round", marginRight: 2, flexDirection: "row" },
        React.createElement(Box, { marginRight: 2 },
            React.createElement(Text, null,
                "configuration: ",
                configurations ? React.createElement(Ok, null) : React.createElement(Ko, null))),
        React.createElement(Box, { marginRight: 2 },
            React.createElement(Text, null,
                "uefi: ",
                uefi ? React.createElement(Ok, null) : React.createElement(Ko, null))),
        React.createElement(Box, { marginRight: 2 },
            React.createElement(Text, null,
                "running on: ",
                Utils.isContainer() ? React.createElement(Container, null) : React.createElement(Host, null))),
        React.createElement(Box, { marginRight: 2 },
            React.createElement(Text, null,
                "init: ",
                React.createElement(Text, { color: "cyan" }, initType))),
        React.createElement(Box, { marginRight: 2 },
            React.createElement(Text, null,
                "installer: ",
                installer ? React.createElement(GUI, null) : React.createElement(CLI, null)))));
    const Presentation = () => (React.createElement(React.Fragment, null,
        React.createElement(Box, null,
            React.createElement(Text, null, " ")),
        React.createElement(Box, { borderStyle: "round", marginRight: 2, flexDirection: "column" },
            React.createElement(Box, null,
                React.createElement(Text, { color: "cyan" }, "eggs krill"),
                React.createElement(Text, null, " install your CLI system with TUI installer krill, on GUI use calamares")),
            React.createElement(Box, null,
                React.createElement(Text, { color: "cyan" }, "eggs wardrobe"),
                React.createElement(Text, null, " build your personal system starting from cli")),
            React.createElement(Box, null,
                React.createElement(Text, null, " ")),
            React.createElement(Box, { flexDirection: "row" },
                React.createElement(Box, { marginRight: 1 },
                    React.createElement(Text, null, "Info: ")),
                React.createElement(Box, { flexDirection: "column" },
                    React.createElement(Box, { marginRight: 2 },
                        React.createElement(Text, null, "blog    "),
                        React.createElement(Text, { color: "cyan" }, "https://penguins-eggs.net")),
                    React.createElement(Box, { marginRight: 2 },
                        React.createElement(Text, null, "sources "),
                        React.createElement(Text, { color: "cyan" }, "https://github.com/pieroproietti/penguins-eggs")),
                    React.createElement(Box, { marginRight: 2 },
                        React.createElement(Text, null, "wardrobe "),
                        React.createElement(Text, { color: "cyan" }, "https://github.com/pieroproietti/penguins-wardrobe")))))));
    /**
     *
     */
    const Main = () => (React.createElement(React.Fragment, null,
        React.createElement(Title, null),
        React.createElement(Box, null,
            React.createElement(Live, null),
            React.createElement(Nest, null),
            React.createElement(Boot, null)),
        React.createElement(Box, null,
            React.createElement(Distro, null),
            React.createElement(RunningOn, null)),
        React.createElement(Presentation, null)));
    render(React.createElement(Main, null));
}
