# (c) Copyright 2022. CodeWeavers, Inc.

from gi.repository import Gdk
from gi.repository import GLib
from gi.repository import Gtk

import bottlecollection
import cxguitools
import cxutils
import iconview
import pyop


class ApplicationsViewController(iconview.IconViewController):

    def __init__(self, parent_window):
        iconview.IconViewController.__init__(self)

        self.xml = Gtk.Builder()
        self.xml.set_translation_domain('crossover')
        self.xml.add_from_file(cxguitools.get_ui_path('applicationsview'))
        self.xml.connect_signals(self)

        self.parent_window = parent_window
        self.bottle = None

        self.xml.get_object('IconView').set_model(self.launcher_list_store)
        self.setup_icon_view(self.xml.get_object('IconView'), True)

        self.bottles = bottlecollection.sharedCollection()
        self.bottles.addChangeDelegate(self)
        self.bottles.addBottleChangeDelegate(self)

        self.update_launchers()

        self.set_drag_destination()

    def get_view(self):
        return self.xml.get_object('ApplicationsView')

    def get_icon_view(self):
        return self.xml.get_object('IconView')

    def update_launchers_for_bottle(self, bottle):
        if bottle.is_busy:
            return

        self.launchers[bottle.name] = {}
        new_launchers = self.launchers_for_bottle(bottle, False)
        for key, launcher in new_launchers.items():
            if key not in self.hidden_launchers:
                self.launchers[bottle.name][key] = launcher

        launchers = {}
        for new_launchers in self.launchers.values():
            launchers.update(new_launchers)

        self.set_launchers(launchers)

    def update_launchers(self):
        self.launchers = {}
        launchers = {}
        bottles = self.bottles.bottles()

        for bottle in bottles:
            if bottle.is_busy:
                continue

            self.launchers[bottle.name] = {}
            new_launchers = self.launchers_for_bottle(bottle, False)
            for key, launcher in new_launchers.items():
                if key not in self.hidden_launchers:
                    self.launchers[bottle.name][key] = launcher
                    launchers[key] = launcher

        self.set_launchers(launchers)

    def set_drag_destination(self):
        view = self.get_view()

        view.drag_dest_set(Gtk.DestDefaults.DROP | Gtk.DestDefaults.MOTION, [], Gdk.DragAction.COPY)
        view.drag_dest_add_uri_targets()
        view.connect('drag-data-received', self.on_drag_data_received)

    def on_drag_data_received(self, _widget, _drag_context, _x, _y, selection_data, _info, _timestamp):
        uris = selection_data.get_uris()
        if uris:
            application = self.parent_window.get_application()
            application.lookup_action('open-file').activate(
                GLib.Variant.new_string(cxutils.uri_to_path(uris[0])))

    def on_ApplicationsView_show(self, _widget):
        self.update_launchers()

    # BottleCollection delegate functions
    def bottleCollectionChanged(self):
        self.update_launchers()

    # BottleWrapper delegate functions
    def bottleChanged(self, bottle):
        assert pyop.is_main_thread()

        if bottle.name not in self.launchers:
            self.update_launchers()
        else:
            self.update_launchers_for_bottle(bottle)
