/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.Arrays;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class TimezoneExpression
extends ASTNodeAccessImpl
implements Expression {
    private final ExpressionList<Expression> timezoneExpressions = new ExpressionList(new Expression[0]);
    private Expression leftExpression;

    public TimezoneExpression() {
        this.leftExpression = null;
    }

    public TimezoneExpression(Expression leftExpression, Expression ... timezoneExpressions) {
        this.leftExpression = leftExpression;
        this.timezoneExpressions.addAll(Arrays.asList(timezoneExpressions));
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public TimezoneExpression setLeftExpression(Expression expression) {
        this.leftExpression = expression;
        return this;
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    public List<Expression> getTimezoneExpressions() {
        return this.timezoneExpressions;
    }

    public void addTimezoneExpression(Expression ... timezoneExpr) {
        this.timezoneExpressions.addAll(Arrays.asList(timezoneExpr));
    }

    @Override
    public String toString() {
        StringBuilder returnValue = new StringBuilder(this.leftExpression.toString());
        for (Expression expr : this.timezoneExpressions) {
            returnValue.append(" AT TIME ZONE ").append(expr.toString());
        }
        return returnValue.toString();
    }
}

