/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.bootimg.BootImageHeaderV1;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class BootImageHeaderV2
extends BootImageHeaderV1 {
    private int dtb_size;
    private long dtb_addr;

    public BootImageHeaderV2(BinaryReader reader) throws IOException {
        super(reader);
        this.dtb_size = reader.readNextInt();
        this.dtb_addr = reader.readNextLong();
    }

    public int getDtbSize() {
        return this.dtb_size;
    }

    public int getDtbSizeAdjusted() {
        return (int)(this.pageAlign(Integer.toUnsignedLong(this.dtb_size)) / (long)this.getPageSize());
    }

    public long getDtbAddress() {
        return this.dtb_addr;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        Structure structure = (Structure)super.toDataType();
        try {
            structure.setName("boot_img_hdr_v2");
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        structure.add(DWORD, "dtb_size", null);
        structure.add(QWORD, "dtb_addr", null);
        return structure;
    }
}

