/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk.v1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.fbpk.FBPK;
import ghidra.file.formats.android.fbpk.FBPK_Partition;
import ghidra.file.formats.android.fbpk.v1.FBPKv1_Partition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FBPKv1
implements FBPK {
    private int magic;
    private int version;
    private String string;
    private int partitionCount;
    private int size;
    private List<FBPK_Partition> partitions = new ArrayList<FBPK_Partition>();

    public FBPKv1(BinaryReader reader) throws IOException {
        this.magic = reader.readNextInt();
        this.version = reader.readNextInt();
        this.string = reader.readNextAsciiString(68);
        this.partitionCount = reader.readNextInt();
        this.size = reader.readNextInt();
        for (int i = 0; i < this.partitionCount; ++i) {
            FBPKv1_Partition partition = new FBPKv1_Partition(reader);
            this.partitions.add(partition);
            reader.setPointerIndex(partition.getOffsetToNextPartitionTable());
        }
    }

    @Override
    public int getMagic() {
        return this.magic;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public String getString() {
        return this.string;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public List<FBPK_Partition> getPartitions() {
        return this.partitions;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(FBPKv1.class.getSimpleName(), 0);
        struct.add(STRING, "FBPK".length(), "magic", null);
        struct.add(DWORD, "version", null);
        struct.add(STRING, 68, "string", null);
        struct.add(DWORD, "partitionCount", null);
        struct.add(DWORD, "size", null);
        return struct;
    }
}

