/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dmg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.file.crypto.CryptoKey;
import ghidra.file.crypto.CryptoKeyFactory;
import ghidra.file.crypto.CryptoUtil;
import ghidra.file.formats.ios.dmg.DmgHeaderV2;
import ghidra.file.formats.ios.generic.iOS_AesCrypto;
import ghidra.file.formats.ios.generic.iOS_Sha1Crypto;
import ghidra.util.exception.CryptoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class DmgDecryptorStream
extends InputStream {
    public static final int DMG_VERSION_2 = 2;
    private int block;
    private int totalBlocks;
    private long index;
    private int remainder;
    private byte[] aes_key;
    private byte[] sha1_key;
    private iOS_Sha1Crypto sha1;
    private ByteProvider provider;
    private int dmgBlockSize;
    private int dmgVersion;
    private byte[] buffer;
    private int bufferposition;

    public DmgDecryptorStream(String containerName, String dmgName, File srcFile) throws IOException {
        this(containerName, dmgName, (ByteProvider)new RandomAccessByteProvider(srcFile));
    }

    public DmgDecryptorStream(String containerName, String dmgName, ByteProvider provider) throws IOException {
        try {
            CryptoKey cryptoKey = CryptoKeyFactory.getCryptoKey(containerName, dmgName);
            if (cryptoKey.key.length != 36) {
                throw new CryptoException("Invalid key length.");
            }
            if (cryptoKey.iv.length != 0) {
                throw new CryptoException("Invalid initialization vector (IV) length.");
            }
            this.aes_key = Arrays.copyOfRange(cryptoKey.key, 0, 16);
            this.sha1_key = Arrays.copyOfRange(cryptoKey.key, 16, 36);
        }
        catch (IOException e) {
            try {
                provider.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        this.provider = provider;
        this.sha1 = new iOS_Sha1Crypto(this.sha1_key);
        BinaryReader reader = new BinaryReader(provider, false);
        DmgHeaderV2 dmg = new DmgHeaderV2(reader);
        this.dmgBlockSize = dmg.getBlockSize();
        this.dmgVersion = dmg.getVersion();
        this.block = 0;
        this.totalBlocks = (int)dmg.getDataSize() / this.dmgBlockSize;
        this.index = dmg.getDataOffset();
        this.remainder = (int)(dmg.getDataSize() % (long)this.dmgBlockSize);
        this.nextBuffer();
    }

    @Override
    public void close() throws IOException {
        this.provider.close();
    }

    private void nextBuffer() throws IOException {
        if (this.block > this.totalBlocks) {
            this.buffer = null;
            this.bufferposition = -1;
            return;
        }
        byte[] iv = DmgDecryptorStream.computeIV(this.sha1, this.block);
        iOS_AesCrypto aes = new iOS_AesCrypto(this.aes_key, iv);
        byte[] encrypedBytes = this.provider.readBytes(this.index, (long)this.dmgBlockSize);
        byte[] decryptedBytes = aes.decrypt(encrypedBytes);
        this.buffer = this.dmgVersion == 2 && this.block == this.totalBlocks && this.remainder > 0 ? Arrays.copyOfRange(decryptedBytes, 0, this.remainder) : decryptedBytes;
        this.bufferposition = 0;
        this.index += (long)this.dmgBlockSize;
        ++this.block;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer != null && this.bufferposition >= this.buffer.length) {
            this.nextBuffer();
        }
        if (this.buffer == null) {
            return -1;
        }
        return this.buffer[this.bufferposition++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer != null && this.bufferposition >= this.buffer.length) {
            this.nextBuffer();
        }
        if (this.buffer == null) {
            return -1;
        }
        int bytesToCopy = Math.min(len, this.buffer.length - this.bufferposition);
        System.arraycopy(this.buffer, this.bufferposition, b, off, bytesToCopy);
        this.bufferposition += bytesToCopy;
        return bytesToCopy;
    }

    private static byte[] computeIV(iOS_Sha1Crypto sha1, int block) throws CryptoException {
        sha1.update(CryptoUtil.htonl(block));
        byte[] bytes = sha1.decrypt();
        byte[] iv = Arrays.copyOfRange(bytes, 0, 16);
        return iv;
    }
}

