/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img3;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ios.img3.Img3;
import ghidra.file.formats.ios.img3.Img3FileSystemFactory;
import ghidra.file.formats.ios.img3.tag.DataTag;
import ghidra.formats.gfilesystem.AbstractFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;

@FileSystemInfo(type="img3", description="iOS Img3", factory=Img3FileSystemFactory.class)
public class Img3FileSystem
extends AbstractFileSystem<DataTag> {
    private ByteProvider provider;

    public Img3FileSystem(FSRLRoot fsFSRL, ByteProvider provider, FileSystemService fsService, TaskMonitor monitor) throws IOException {
        super(fsFSRL, fsService);
        this.provider = provider;
        monitor.setMessage("Opening IMG3...");
        Img3 header = new Img3(provider);
        if (!header.getMagic().equals("Img3")) {
            throw new IOException("Unable to decrypt file: invalid IMG3 file!");
        }
        List<DataTag> tags = header.getTags(DataTag.class);
        monitor.initialize((long)tags.size());
        for (int i = 0; i < tags.size() && !monitor.isCancelled(); ++i) {
            monitor.setProgress((long)i);
            DataTag dataTag = tags.get(i);
            String filename = this.getDataTagFilename(dataTag, i, tags.size() > 1);
            this.fsIndex.storeFileWithParent(filename, this.fsIndex.getRootDir(), (long)i, false, (long)dataTag.getTotalLength(), (Object)dataTag);
        }
    }

    private String getDataTagFilename(DataTag dataTag, int index, boolean isMulti) {
        String filename = dataTag.getMagic();
        return isMulti ? filename + index : filename;
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.fsIndex.clear();
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.fsFSRL.getNestingDepth() < 3) {
            throw new CryptoException("Unable to decrypt IMG3 data because IMG3 crypto keys are specific to the container it is embedded in and this IMG3 was not in a container");
        }
        DataTag dataTag = (DataTag)this.fsIndex.getMetadata(file);
        if (dataTag == null) {
            throw new IOException("Unknown file: " + String.valueOf(file));
        }
        ByteProvider derivedBP = this.fsService.getDerivedByteProvider(this.fsFSRL.getContainer(), file.getFSRL(), "decrypted_img3_" + file.getName(), (long)dataTag.getTotalLength(), () -> dataTag.getDecryptedInputStream(this.fsFSRL.getName(2), this.fsFSRL.getName(1)), monitor);
        return derivedBP;
    }

    public Icon getIcon() {
        return null;
    }

    public boolean isClosed() {
        return this.provider == null;
    }
}

