/*
 * Decompiled with CFR 0.152.
 */
package generic.constraint;

import ghidra.util.xml.XmlAttributeException;
import java.util.HashMap;
import java.util.Map;

public class ConstraintData {
    private Map<String, String> map = new HashMap<String, String>();

    public ConstraintData(Map<String, String> mappings) {
        this.map.putAll(mappings);
    }

    public String getString(String name) {
        return this.getValue(name, "string");
    }

    public boolean hasValue(String name) {
        return this.map.containsKey(name);
    }

    public int getInt(String name) {
        String value = this.getValue(name, "int");
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new XmlAttributeException("Expected int value for attribute \"" + name + "\", but was \"" + value + "\"");
        }
    }

    public long getLong(String name) {
        String value = this.getValue(name, "long");
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new XmlAttributeException("Expected long value for attribute \"" + name + "\", but was \"" + value + "\"");
        }
    }

    public boolean getBoolean(String name) {
        String value = this.getValue(name, "boolean");
        if ((value = value.toLowerCase()).equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new XmlAttributeException("Expected boolean value for attribute \"" + name + "\", but was \"" + value + "\"");
    }

    public float getFloat(String name) {
        String value = this.getValue(name, "float");
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new XmlAttributeException("Expected float value for attribute \"" + name + "\", but was \"" + value + "\"");
        }
    }

    public double getDouble(String name) {
        String value = this.getValue(name, "double");
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new XmlAttributeException("Expected double value for attribute \"" + name + "\", but was \"" + value + "\"");
        }
    }

    private String getValue(String name, String type) {
        String value = this.map.get(name);
        if (value == null) {
            throw new XmlAttributeException("Missing " + type + " value for attribute \"" + name + "\"");
        }
        return value;
    }
}

