/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.generic.auth;

import java.io.Closeable;
import java.util.Arrays;

public class Password
implements Closeable {
    private char[] password;

    public static Password copyOf(char[] password) {
        Password result = new Password();
        result.password = new char[password.length];
        System.arraycopy(password, 0, result.password, 0, password.length);
        return result;
    }

    public static Password wrap(char[] password) {
        Password result = new Password();
        result.password = password;
        return result;
    }

    private Password() {
    }

    public Password clone() {
        return Password.copyOf(this.password);
    }

    @Override
    public void close() {
        Arrays.fill(this.password, '\u0000');
        this.password = null;
    }

    public char[] getPasswordChars() {
        return this.password;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.password);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Password other = (Password)obj;
        return Arrays.equals(this.password, other.password);
    }
}

