/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.stackeditor;

import docking.ActionContext;
import docking.ComponentProvider;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.compositeeditor.ApplyAction;
import ghidra.app.plugin.core.compositeeditor.ArrayAction;
import ghidra.app.plugin.core.compositeeditor.ClearAction;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.compositeeditor.DeleteAction;
import ghidra.app.plugin.core.compositeeditor.EditComponentAction;
import ghidra.app.plugin.core.compositeeditor.EditFieldAction;
import ghidra.app.plugin.core.compositeeditor.HexNumbersAction;
import ghidra.app.plugin.core.compositeeditor.PointerAction;
import ghidra.app.plugin.core.compositeeditor.ShowComponentPathAction;
import ghidra.app.plugin.core.stackeditor.StackEditorModel;
import ghidra.app.plugin.core.stackeditor.StackEditorPanel;
import ghidra.app.plugin.core.stackeditor.StackFrameDataType;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.util.task.SwingUpdateManager;
import java.awt.event.MouseEvent;

public class StackEditorProvider
extends CompositeEditorProvider<StackFrameDataType, StackEditorModel>
implements DomainObjectListener {
    private Program program;
    private Function function;
    private StackEditorModel stackModel;
    boolean scheduleRefreshName = false;
    boolean scheduleReload = false;
    SwingUpdateManager delayedUpdateMgr = new SwingUpdateManager(200, 200, () -> {
        try {
            if (this.function.isDeleted()) {
                this.stackModel.functionChanged(false);
                return;
            }
            if (this.scheduleRefreshName) {
                this.updateTitle();
            }
            if (this.scheduleReload) {
                this.stackModel.functionChanged(false);
            }
        }
        finally {
            this.scheduleRefreshName = false;
            this.scheduleReload = false;
        }
    });

    public StackEditorProvider(Plugin plugin, Function function) {
        super(plugin);
        this.program = function.getProgram();
        this.function = function;
        this.program.addListener((DomainObjectListener)this);
        this.editorModel = new StackEditorModel(this);
        this.stackModel = (StackEditorModel)this.editorModel;
        this.stackModel.load(function);
        this.initializeActions();
        this.editorPanel = new StackEditorPanel(this.program, this.stackModel, this);
        this.updateTitle();
        plugin.getTool().addComponentProvider((ComponentProvider)this, true);
        this.addActionsToTool();
        this.editorPanel.getTable().requestFocus();
    }

    @Override
    protected void updateTitle() {
        this.setTabText(this.function.getName());
        this.setTitle(this.getName() + " - " + StackEditorProvider.getProviderSubTitle(this.function));
    }

    @Override
    public void dispose() {
        this.delayedUpdateMgr.dispose();
        this.program.removeListener((DomainObjectListener)this);
        super.dispose();
    }

    static String getProviderSubTitle(Function function) {
        Program pgm = function.getProgram();
        return function.getName() + " (" + pgm.getDomainFile().getName() + ")";
    }

    @Override
    protected Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getName() {
        return "Stack Editor";
    }

    @Override
    protected String getDisplayName() {
        return "stack frame: " + this.function.getName();
    }

    @Override
    public String getHelpName() {
        return "Stack_Editor";
    }

    @Override
    public String getHelpTopic() {
        return "StackEditor";
    }

    @Override
    protected CompositeEditorTableAction[] createActions() {
        return new CompositeEditorTableAction[]{new ApplyAction(this), new ClearAction(this), new DeleteAction(this), new PointerAction(this), new ArrayAction(this), new ShowComponentPathAction(this), new EditComponentAction(this), new EditFieldAction(this), new HexNumbersAction(this)};
    }

    @Override
    public ActionContext getActionContext(MouseEvent event) {
        return new ProgramActionContext((ComponentProvider)this, this.program);
    }

    String getStackName() {
        return this.stackModel.getEditorStack().getDisplayName();
    }

    Function getFunction() {
        StackFrameDataType editorStack = this.stackModel.getEditorStack();
        if (editorStack == null) {
            return null;
        }
        return editorStack.getFunction();
    }

    @Override
    public boolean isEditing(DataTypePath functionPath) {
        return this.getDtPath().equals((Object)functionPath);
    }

    protected Program getProgram() {
        return this.program;
    }

    protected StackEditorModel getModel() {
        return this.stackModel;
    }

    @Override
    protected CompositeEditorTableAction[] getActions() {
        return this.actionMgr.getAllActions();
    }

    public void domainObjectChanged(DomainObjectChangedEvent event) {
        if (!this.isVisible()) {
            return;
        }
        int recordCount = event.numRecords();
        block6: for (int i = 0; i < recordCount; ++i) {
            DomainObjectChangeRecord rec = event.getChangeRecord(i);
            EventType eventType = rec.getEventType();
            if (eventType == DomainObjectEvent.FILE_CHANGED) {
                this.scheduleRefreshName = true;
                this.delayedUpdateMgr.updateLater();
                continue;
            }
            if (!(eventType instanceof ProgramEvent)) continue;
            ProgramEvent type = (ProgramEvent)eventType;
            switch (type) {
                case FUNCTION_REMOVED: {
                    Function func = (Function)((ProgramChangeRecord)rec).getObject();
                    if (func != this.function) continue block6;
                    this.tool.setStatusInfo("Stack Editor was closed for " + this.getName());
                    this.dispose();
                    return;
                }
                case SYMBOL_RENAMED: 
                case SYMBOL_DATA_CHANGED: {
                    Symbol sym = (Symbol)((ProgramChangeRecord)rec).getObject();
                    if (sym.isPrimary() && sym.getAddress().equals((Object)this.function.getEntryPoint())) {
                        this.scheduleRefreshName = true;
                        this.delayedUpdateMgr.updateLater();
                        continue block6;
                    }
                    if (!this.inCurrentFunction(rec)) continue block6;
                    this.scheduleReload = true;
                    this.delayedUpdateMgr.updateLater();
                    continue block6;
                }
                case FUNCTION_CHANGED: 
                case SYMBOL_ADDED: 
                case SYMBOL_REMOVED: 
                case SYMBOL_ADDRESS_CHANGED: {
                    if (!this.inCurrentFunction(rec)) continue block6;
                    this.scheduleReload = true;
                    this.delayedUpdateMgr.updateLater();
                    continue block6;
                }
                case SYMBOL_PRIMARY_STATE_CHANGED: {
                    Symbol sym = (Symbol)((ProgramChangeRecord)rec).getNewValue();
                    if (!sym.getAddress().equals((Object)this.function.getEntryPoint())) continue block6;
                    this.scheduleRefreshName = true;
                    this.delayedUpdateMgr.updateLater();
                    continue block6;
                }
            }
        }
    }

    private boolean inCurrentFunction(DomainObjectChangeRecord record) {
        Address changedEntry;
        if (!(record instanceof ProgramChangeRecord)) {
            return false;
        }
        if (this.function == null) {
            return false;
        }
        ProgramChangeRecord programChangeRecord = (ProgramChangeRecord)record;
        Object affectedValue = programChangeRecord.getObject();
        if (affectedValue instanceof Symbol) {
            Address address = ((Symbol)affectedValue).getAddress();
            if (address.isVariableAddress()) {
                Symbol s = (Symbol)affectedValue;
                return s.getParentNamespace() == this.function;
            }
        } else if (affectedValue instanceof Function && (changedEntry = ((Function)affectedValue).getEntryPoint()).equals((Object)this.function.getEntryPoint())) {
            return true;
        }
        return false;
    }
}

