/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import docking.widgets.combobox.GComboBox;
import docking.widgets.label.GDLabel;
import ghidra.framework.options.CustomOptionsEditor;
import ghidra.util.ManualViewerCommandWrappedOption;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ManualViewerCommandEditor
extends PropertyEditorSupport
implements CustomOptionsEditor {
    private static final String FILE_FORMAT_DESCRIPTION = "This determines the format of the URL that is sent to the process above.  If ${HTTP_URL} is chosen, then an HTTP URL will be passed to the process.  If ${FILE_URL} is chosen, the a File URL will be sent to the process.  If ${FILENAME} is chosen, then only the file path will be sent to the process.";
    private static final String COMMAND_STRING_DESCRIPTION = "This is the name of, or a full path to an executable that will be launched to open the processor manual.  Examples include 'firefox', 'netscape', 'open', etc.";
    private static final String COMMAND_ARGUMENTS_DESCRIPTION = "These are the arguments that will be passed to the command given in the 'Command String' field.";
    private static final String[] DESCRIPTIONS = new String[]{"This determines the format of the URL that is sent to the process above.  If ${HTTP_URL} is chosen, then an HTTP URL will be passed to the process.  If ${FILE_URL} is chosen, the a File URL will be sent to the process.  If ${FILENAME} is chosen, then only the file path will be sent to the process.", "This is the name of, or a full path to an executable that will be launched to open the processor manual.  Examples include 'firefox', 'netscape', 'open', etc.", "These are the arguments that will be passed to the command given in the 'Command String' field."};
    private static final String FILE_FORMAT_LABEL = "File Format: ";
    private static final String COMMAND_ARGUMENTS_LABEL = "Command Arguments: ";
    private static final String COMMAND_STRING_LABEL = "Command String: ";
    private static final String[] NAMES = new String[]{"File Format: ", "Command String: ", "Command Arguments: "};
    private ManualViewerCommandWrappedOption wrappedOption;
    private LaunchDataInputPanel editorComponent = new LaunchDataInputPanel();
    private JTextField commandField;
    private JTextField argumentsField;
    private JComboBox<String> fileFormatComboBox;

    public String[] getOptionDescriptions() {
        return DESCRIPTIONS;
    }

    public String[] getOptionNames() {
        return NAMES;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.editorComponent;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof ManualViewerCommandWrappedOption)) {
            return;
        }
        this.wrappedOption = (ManualViewerCommandWrappedOption)value;
        this.editorComponent.setOption(this.wrappedOption);
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this.cloneCommandOptions();
    }

    private ManualViewerCommandWrappedOption cloneCommandOptions() {
        ManualViewerCommandWrappedOption newOption = new ManualViewerCommandWrappedOption();
        newOption.setCommandString(this.commandField.getText());
        try {
            newOption.setCommandArguments(this.parseArguments(this.argumentsField.getText()));
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Unable to Parse Command Arguments", (Object)("Unable to parse command arguments: " + this.argumentsField.getText()), (Throwable)e);
            return this.wrappedOption;
        }
        newOption.setUrlReplacementString((String)this.fileFormatComboBox.getSelectedItem());
        return newOption;
    }

    private String[] parseArguments(String argumentString) throws IOException {
        int tokenType;
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(argumentString));
        tokenizer.resetSyntax();
        tokenizer.wordChars(33, 126);
        tokenizer.wordChars(160, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.quoteChar(34);
        tokenizer.eolIsSignificant(false);
        tokenizer.slashSlashComments(false);
        tokenizer.slashStarComments(false);
        tokenizer.lowerCaseMode(false);
        ArrayList<Object> argumentList = new ArrayList<Object>();
        while ((tokenType = tokenizer.nextToken()) != -1) {
            if (tokenType == -3) {
                argumentList.add(tokenizer.sval);
                continue;
            }
            if (tokenType == -2) {
                argumentList.add(Double.toString(tokenizer.nval));
                continue;
            }
            if (tokenizer.ttype != 34) continue;
            argumentList.add("\"" + tokenizer.sval + "\"");
        }
        return argumentList.toArray(new String[argumentList.size()]);
    }

    class LaunchDataInputPanel
    extends JPanel {
        private LaunchDataInputPanel() {
            this.add(this.createWorkPanel());
        }

        void setOption(ManualViewerCommandWrappedOption option) {
            ManualViewerCommandEditor.this.commandField.setText(option.getCommandString());
            String[] commandArguments = option.getCommandArguments();
            StringBuffer buffer = new StringBuffer();
            for (String string : commandArguments) {
                buffer.append(string);
                buffer.append(" ");
            }
            ManualViewerCommandEditor.this.argumentsField.setText(buffer.toString().trim());
            ManualViewerCommandEditor.this.fileFormatComboBox.setSelectedItem(option.getUrlReplacementString());
        }

        ManualViewerCommandWrappedOption getOption() {
            ManualViewerCommandWrappedOption option = new ManualViewerCommandWrappedOption();
            option.setCommandString(ManualViewerCommandEditor.this.commandField.getText());
            String text = ManualViewerCommandEditor.this.argumentsField.getText();
            StringTokenizer tokenizer = new StringTokenizer(text, " ");
            int size = tokenizer.countTokens();
            String[] arguments = new String[size];
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = tokenizer.nextToken();
            }
            option.setCommandArguments(arguments);
            option.setUrlReplacementString((String)ManualViewerCommandEditor.this.fileFormatComboBox.getSelectedItem());
            return option;
        }

        private JComponent createWorkPanel() {
            JPanel workPanel = new JPanel();
            workPanel.setBorder(BorderFactory.createBevelBorder(1));
            workPanel.setLayout((LayoutManager)new PairLayout());
            GDLabel commandLabel = new GDLabel(ManualViewerCommandEditor.COMMAND_STRING_LABEL);
            commandLabel.setToolTipText(ManualViewerCommandEditor.COMMAND_STRING_DESCRIPTION);
            ManualViewerCommandEditor.this.commandField = new JTextField(30);
            GDLabel argumentsLabel = new GDLabel(ManualViewerCommandEditor.COMMAND_ARGUMENTS_LABEL);
            argumentsLabel.setToolTipText(ManualViewerCommandEditor.COMMAND_ARGUMENTS_DESCRIPTION);
            ManualViewerCommandEditor.this.argumentsField = new JTextField(20);
            GDLabel formatLabel = new GDLabel(ManualViewerCommandEditor.FILE_FORMAT_LABEL);
            formatLabel.setToolTipText(ManualViewerCommandEditor.FILE_FORMAT_DESCRIPTION);
            ManualViewerCommandEditor.this.fileFormatComboBox = new GComboBox();
            ManualViewerCommandEditor.this.fileFormatComboBox.addItem("${HTTP_URL}");
            ManualViewerCommandEditor.this.fileFormatComboBox.addItem("${FILE_URL}");
            ManualViewerCommandEditor.this.fileFormatComboBox.addItem("${FILENAME}");
            ManualViewerCommandEditor.this.fileFormatComboBox.setSelectedIndex(0);
            commandLabel.setHorizontalAlignment(4);
            workPanel.add((Component)commandLabel);
            workPanel.add(ManualViewerCommandEditor.this.commandField);
            argumentsLabel.setHorizontalAlignment(4);
            workPanel.add((Component)argumentsLabel);
            workPanel.add(ManualViewerCommandEditor.this.argumentsField);
            formatLabel.setHorizontalAlignment(4);
            workPanel.add((Component)formatLabel);
            workPanel.add(ManualViewerCommandEditor.this.fileFormatComboBox);
            ManualViewerCommandEditor.this.commandField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ManualViewerCommandEditor.this.firePropertyChange();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ManualViewerCommandEditor.this.firePropertyChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ManualViewerCommandEditor.this.firePropertyChange();
                }
            });
            ManualViewerCommandEditor.this.argumentsField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ManualViewerCommandEditor.this.firePropertyChange();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ManualViewerCommandEditor.this.firePropertyChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ManualViewerCommandEditor.this.firePropertyChange();
                }
            });
            ManualViewerCommandEditor.this.fileFormatComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ManualViewerCommandEditor.this.firePropertyChange();
                }
            });
            return workPanel;
        }
    }
}

