/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import ghidra.app.plugin.core.debug.gui.tracermi.launcher.AbstractScriptTraceRmiLaunchOffer;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.ScriptAttributesParser;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.debug.api.ValStr;
import ghidra.program.model.listing.Program;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;

public class PowerShellScriptTraceRmiLaunchOffer
extends AbstractScriptTraceRmiLaunchOffer {
    public static final String REM = "#";
    public static final int REM_LEN = "#".length();

    public static PowerShellScriptTraceRmiLaunchOffer create(TraceRmiLauncherServicePlugin plugin, Program program, File script) throws FileNotFoundException {
        ScriptAttributesParser parser = new ScriptAttributesParser(){

            @Override
            protected boolean ignoreLine(int lineNo, String line) {
                return line.isBlank();
            }

            @Override
            protected String removeDelimiter(String line) {
                String stripped = line.stripLeading();
                if (!stripped.startsWith(PowerShellScriptTraceRmiLaunchOffer.REM)) {
                    return null;
                }
                return stripped.substring(REM_LEN);
            }
        };
        ScriptAttributesParser.ScriptAttributes attrs = parser.parseFile(script);
        return new PowerShellScriptTraceRmiLaunchOffer(plugin, program, script, "PS1_FILE:" + script.getName(), attrs);
    }

    private PowerShellScriptTraceRmiLaunchOffer(TraceRmiLauncherServicePlugin plugin, Program program, File script, String configName, ScriptAttributesParser.ScriptAttributes attrs) {
        super(plugin, program, script, configName, attrs);
    }

    @Override
    protected void prepareSubprocess(List<String> commandLine, Map<String, String> env, Map<String, ValStr<?>> args, SocketAddress address) {
        super.prepareSubprocess(commandLine, env, args, address);
        commandLine.addAll(0, List.of("powershell", "-File"));
    }
}

