/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.internal.BinarySpecInternal;

public class DefaultBinaryTasksCollection
extends DefaultDomainObjectSet<Task>
implements BinaryTasksCollection {
    private final BinarySpecInternal binary;
    private final NamedEntityInstantiator<Task> taskInstantiator;

    public DefaultBinaryTasksCollection(BinarySpecInternal binarySpecInternal, NamedEntityInstantiator<Task> taskInstantiator, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
        super(Task.class, collectionCallbackActionDecorator);
        this.binary = binarySpecInternal;
        this.taskInstantiator = taskInstantiator;
    }

    @Override
    public String taskName(String verb) {
        return verb + StringUtils.capitalize((String)this.binary.getProjectScopedName());
    }

    @Override
    public String taskName(String verb, String object) {
        return verb + StringUtils.capitalize((String)this.binary.getProjectScopedName()) + StringUtils.capitalize((String)object);
    }

    @Override
    public Task getBuild() {
        return this.binary.getBuildTask();
    }

    @Override
    public Task getCheck() {
        return this.binary.getCheckTask();
    }

    public <T extends Task> T findSingleTaskWithType(Class<T> type) {
        DomainObjectSet tasks = this.withType(type);
        if (tasks.size() == 0) {
            return null;
        }
        if (tasks.size() > 1) {
            throw new UnknownDomainObjectException(String.format("Multiple tasks with type '%s' found.", type.getSimpleName()));
        }
        return (T)((Task)tasks.iterator().next());
    }

    @Override
    public <T extends Task> void create(String name, Class<T> type, Action<? super T> config) {
        Task task = (Task)this.taskInstantiator.create(name, type);
        this.add(task);
        config.execute((Object)task);
    }
}

