/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.FilteredFileTree;
import org.gradle.api.internal.file.UnionFileTree;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSetFactory;
import org.gradle.internal.Cast;
import org.gradle.util.internal.ConfigureUtil;

public abstract class CompositeFileTree
extends CompositeFileCollection
implements FileTreeInternal {
    public CompositeFileTree(TaskDependencyFactory taskDependencyFactory, PatternSetFactory patternSetFactory) {
        super(taskDependencyFactory, patternSetFactory);
    }

    public CompositeFileTree(TaskDependencyFactory taskDependencyFactory) {
        super(taskDependencyFactory);
    }

    public CompositeFileTree() {
    }

    protected List<? extends FileTreeInternal> getSourceCollections() {
        return (List)Cast.uncheckedNonnullCast(super.getSourceCollections());
    }

    public FileTree plus(FileTree fileTree) {
        return new UnionFileTree(this.taskDependencyFactory, this, (FileTreeInternal)Cast.cast(FileTreeInternal.class, (Object)fileTree));
    }

    public FileTree matching(Closure filterConfigClosure) {
        return this.newFilteredFileTree(() -> (PatternSet)ConfigureUtil.configure((Closure)filterConfigClosure, (Object)this.patternSetFactory.createPatternSet()));
    }

    public FileTree matching(Action<? super PatternFilterable> filterConfigAction) {
        return this.newFilteredFileTree(() -> {
            PatternSet patternSet = this.patternSetFactory.createPatternSet();
            filterConfigAction.execute((Object)patternSet);
            return patternSet;
        });
    }

    @Override
    public FileTreeInternal matching(PatternFilterable patterns) {
        return this.newFilteredFileTree(() -> {
            if (patterns instanceof PatternSet) {
                return (PatternSet)patterns;
            }
            PatternSet patternSet = this.patternSetFactory.createPatternSet();
            patternSet.copyFrom(patterns);
            return patternSet;
        });
    }

    public FileTree visit(Closure visitor) {
        return this.visit(AbstractFileTree.fileVisitorFrom(visitor));
    }

    public FileTree visit(Action<? super FileVisitDetails> visitor) {
        for (FileTree fileTree : this.getSourceCollections()) {
            fileTree.visit(visitor);
        }
        return this;
    }

    public FileTree visit(FileVisitor visitor) {
        for (FileTree fileTree : this.getSourceCollections()) {
            fileTree.visit(visitor);
        }
        return this;
    }

    @Override
    public FileTreeInternal getAsFileTree() {
        return this;
    }

    @Override
    public void visitContentsAsFileTrees(Consumer<FileTreeInternal> visitor) {
        this.visitChildren(child -> visitor.accept((FileTreeInternal)child));
    }

    private FileTreeInternal newFilteredFileTree(Supplier<? extends PatternSet> patternSetSupplier) {
        return new FilteredFileTree(this, this.taskDependencyFactory, this.patternSetFactory, patternSetSupplier);
    }
}

