#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-utils
version:              1.10.0
visibility:           public
id:                   tamarin-prover-utils-1.10.0-KegB8iQu0YkGYjq48w99kc
key:                  tamarin-prover-utils-1.10.0-KegB8iQu0YkGYjq48w99kc
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Cas Cremers <cremers@cispa.de>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Utility library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

category:             Theorem Provers
abi:                  5a3234fb59dd45472d2eb00950bbab6c
exposed:              True
exposed-modules:
    Control.Basics Control.Monad.Bind Control.Monad.Disj
    Control.Monad.Fresh Control.Monad.Trans.FastFresh
    Control.Monad.Trans.PreciseFresh Data.Color Data.DAG.Simple
    Debug.Trace.EnvTracer Debug.Trace.Ignore Extension.Data.ByteString
    Extension.Data.Label Extension.Data.Monoid Extension.Prelude
    Logic.Connectives System.Timing Text.Dot Text.PrettyPrint.Class
    Text.PrettyPrint.Highlight Text.PrettyPrint.Html Text.Unicode
    Utils.Misc

hidden-modules:
    Control.Monad.Fresh.Class Control.Monad.Trans.Disj
    Control.Monad.Disj.Class

import-dirs:          /usr/lib/ghc-9.6.6/site-local/tamarin-prover-utils-1.10.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/tamarin-prover-utils-1.10.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/tamarin-prover-utils-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-utils
hs-libraries:         HStamarin-prover-utils-1.10.0-KegB8iQu0YkGYjq48w99kc
depends:
    SHA-1.6.4.4-KRZJCS52poaHfqPlW5b8Sg base-4.18.2.1
    base64-bytestring-1.2.1.0-B0w0hfBZVmq3UW6lmjr7G binary-0.8.9.1
    blaze-builder-0.4.4.1-ANrFLGaR0ME9lTajIuX8Fb bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.1 dlist-1.0-B7D1vsARFiIHVaGk5CGbYO
    exceptions-0.10.7 fclabels-2.0.5.1-3YelYxEPdt85B7Mq0wU3QH
    graphviz-2999.20.2.1-HYVGy8neXVyBSPlU56G033
    list-t-1.0.5.7-EM5zr1thpvoLHIkxHFphV1 mtl-2.3.1 pretty-1.1.3.6
    safe-0.3.21-EsRFO8M87PCEtDqVSuBNfo
    split-0.2.5-LIo01L9HFTI75RwsLzYVkn syb-0.7.3-7GPFF4ffw0kLXaCjDkD2wt
    text-2.0.2 time-1.12.2 transformers-0.6.1.0

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-utils/html/tamarin-prover-utils.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-utils/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

