/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.dynatrace.hash4j.hashing.HashSink;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hashing;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetHashSupplier;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.model.module.JpsModule;

public final class BuildTargetConfiguration {
    public static final Key<Set<JpsModule>> MODULES_WITH_TARGET_CONFIG_CHANGED_KEY = GlobalContextKey.create("_modules_with_target_config_changed_");
    private static final Logger LOG = Logger.getInstance(BuildTargetConfiguration.class);
    private static final GlobalContextKey<Set<File>> ALL_DELETED_ROOTS_KEY = GlobalContextKey.create("_all_deleted_output_roots_");
    private static final String DIRTY_MARK = "$dirty_mark$";
    private final BuildTarget<?> target;
    @NotNull
    private final BuildDataPaths dataPaths;
    @NotNull
    private String configuration;
    private volatile String currentState;

    @ApiStatus.Internal
    public BuildTargetConfiguration(@NotNull BuildTarget<?> target, @NotNull BuildDataPaths dataPaths) {
        if (target == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(0);
        }
        if (dataPaths == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(1);
        }
        this.target = target;
        this.dataPaths = dataPaths;
        this.configuration = this.load();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private String load() {
        String string;
        try {
            string = Files.readString(this.getConfigFile());
        }
        catch (NoSuchFileException noSuchFileException) {
            return "";
        }
        catch (IOException e) {
            LOG.warn("Cannot load configuration of " + String.valueOf(this.target), (Throwable)e);
            return "";
        }
        if (string != null) return string;
        BuildTargetConfiguration.$$$reportNull$$$0(2);
        return string;
    }

    public boolean isTargetDirty(@NotNull ProjectDescriptor projectDescriptor) {
        if (projectDescriptor == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(3);
        }
        return DIRTY_MARK.equals(this.configuration) || !this.getCurrentState(projectDescriptor).equals(this.configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDiagnostics(CompileContext context) {
        if (DIRTY_MARK.equals(this.configuration)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.valueOf(this.target) + " has been marked dirty in the previous compilation session");
            }
        } else {
            String currentState = this.getCurrentState(context.getProjectDescriptor());
            if (currentState.equals(this.configuration)) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.valueOf(this.target) + " configuration was changed:");
                LOG.debug("Old: " + this.configuration);
                LOG.debug("New: " + currentState);
                LOG.debug(String.valueOf(this.target) + " will be recompiled");
            }
            if (this.target instanceof ModuleBuildTarget) {
                JpsModule module = ((ModuleBuildTarget)this.target).getModule();
                Key<Set<JpsModule>> key = MODULES_WITH_TARGET_CONFIG_CHANGED_KEY;
                synchronized (key) {
                    HashSet<JpsModule> modules = (HashSet<JpsModule>)MODULES_WITH_TARGET_CONFIG_CHANGED_KEY.get((UserDataHolder)context);
                    if (modules == null) {
                        modules = new HashSet<JpsModule>();
                        MODULES_WITH_TARGET_CONFIG_CHANGED_KEY.set((UserDataHolder)context, modules);
                    }
                    modules.add(module);
                }
            }
        }
    }

    public void save(@NotNull CompileContext context) {
        if (context == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(4);
        }
        this.persist(this.getCurrentState(context.getProjectDescriptor()));
    }

    void invalidate() {
        this.persist(DIRTY_MARK);
    }

    private void persist(@NotNull String data) {
        if (data == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(5);
        }
        try {
            Path configFile = this.getConfigFile();
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            Files.writeString(configFile, (CharSequence)data, new OpenOption[0]);
            this.configuration = data;
        }
        catch (IOException e) {
            LOG.info("Cannot save configuration of " + this.configuration, (Throwable)e);
        }
    }

    @NotNull
    private Path getConfigFile() {
        Path path = this.dataPaths.getTargetDataRootDir(this.target).resolve("config.dat");
        if (path == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(6);
        }
        return path;
    }

    @NotNull
    private Path getNonexistentOutputsFile() {
        Path path = this.dataPaths.getTargetDataRootDir(this.target).resolve("nonexistent-outputs.dat");
        if (path == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(7);
        }
        return path;
    }

    @NotNull
    private String getCurrentState(@NotNull ProjectDescriptor projectDescriptor) {
        String state;
        if (projectDescriptor == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(8);
        }
        if ((state = this.currentState) != null) {
            String string = state;
            if (string == null) {
                BuildTargetConfiguration.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (this.target instanceof BuildTargetHashSupplier) {
            HashStream64 hash = Hashing.komihash5_0().hashStream();
            ((BuildTargetHashSupplier)((Object)this.target)).computeConfigurationDigest(projectDescriptor, (HashSink)hash);
            state = Long.toUnsignedString(hash.getAsLong(), 36);
        } else {
            StringWriter out = new StringWriter();
            this.target.writeConfiguration(projectDescriptor, new PrintWriter(out));
            state = out.toString();
        }
        this.currentState = state;
        String string = state;
        if (string == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(10);
        }
        return string;
    }

    void storeNonExistentOutputRoots(@NotNull CompileContext context) throws IOException {
        if (context == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(11);
        }
        PathRelativizerService relativizer = context.getProjectDescriptor().dataManager.getRelativizer();
        Collection<File> outputRoots = this.target.getOutputRoots(context);
        ArrayList<String> nonexistentOutputRoots = new ArrayList<String>();
        for (File root : outputRoots) {
            if (root.exists()) continue;
            nonexistentOutputRoots.add(relativizer.toRelative(root.getAbsolutePath()));
        }
        Path file = this.getNonexistentOutputsFile();
        if (nonexistentOutputRoots.isEmpty()) {
            Files.deleteIfExists(file);
        } else {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.writeString(file, (CharSequence)String.join((CharSequence)"\n", nonexistentOutputRoots), new OpenOption[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean outputRootWasDeleted(CompileContext context) throws IOException {
        Set storedNonExistentOutputs;
        ArrayList<String> nonexistentOutputRoots = new ArrayList<String>();
        Collection<File> targetRoots = this.target.getOutputRoots(context);
        GlobalContextKey<Set<File>> globalContextKey = ALL_DELETED_ROOTS_KEY;
        synchronized (globalContextKey) {
            Set allDeletedRoots = (Set)ALL_DELETED_ROOTS_KEY.get(context);
            for (File outputRoot : targetRoots) {
                boolean wasDeleted;
                boolean bl = wasDeleted = allDeletedRoots != null && allDeletedRoots.contains(outputRoot);
                if (!wasDeleted) {
                    boolean bl2 = wasDeleted = !outputRoot.exists();
                    if (wasDeleted) {
                        if (allDeletedRoots == null) {
                            allDeletedRoots = FileCollectionFactory.createCanonicalFileSet();
                            ALL_DELETED_ROOTS_KEY.set(context, allDeletedRoots);
                        }
                        allDeletedRoots.add(outputRoot);
                    }
                }
                if (!wasDeleted) continue;
                nonexistentOutputRoots.add(FileUtilRt.toSystemIndependentName((String)outputRoot.getAbsolutePath()));
            }
        }
        if (nonexistentOutputRoots.isEmpty()) {
            return false;
        }
        Path file = this.getNonexistentOutputsFile();
        if (Files.notExists(file, new LinkOption[0])) {
            storedNonExistentOutputs = Set.of();
        } else {
            PathRelativizerService relativizer = context.getProjectDescriptor().dataManager.getRelativizer();
            List lines = ContainerUtil.map((Collection)StringUtil.split((String)Files.readString(file), (String)"\n"), s -> relativizer.toFull((String)s));
            storedNonExistentOutputs = CollectionFactory.createFilePathSet((Collection)lines);
        }
        return !storedNonExistentOutputs.containsAll(nonexistentOutputRoots);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildTargetConfiguration";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDescriptor";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildTargetConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonexistentOutputsFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTargetDirty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "persist";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "storeNonExistentOutputRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

