/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.jdom.Namespace;

public class EclipseNamespaceStack {
    private final Deque<NamespaceInfo> myNamespaces = new ArrayDeque<NamespaceInfo>();

    public void push(Namespace ns) {
        this.myNamespaces.push(new NamespaceInfo(ns.getPrefix(), ns.getURI()));
    }

    public String pop() {
        return this.myNamespaces.pop().prefix;
    }

    public int size() {
        return this.myNamespaces.size();
    }

    public String getURI(String prefix) {
        Iterator<NamespaceInfo> iterator = this.myNamespaces.descendingIterator();
        while (iterator.hasNext()) {
            NamespaceInfo ns = iterator.next();
            if (!ns.prefix.equals(prefix)) continue;
            return ns.uri;
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String sep = System.lineSeparator();
        buf.append("Stack: ").append(this.myNamespaces.size()).append(sep);
        for (NamespaceInfo info : this.myNamespaces) {
            buf.append(info).append(sep);
        }
        return buf.toString();
    }

    static class NamespaceInfo {
        final String prefix;
        final String uri;

        NamespaceInfo(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        public String toString() {
            return this.prefix + "&" + this.uri;
        }
    }
}

