/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.dependencies;

import com.intellij.compiler.instrumentation.FailSafeClassReader;
import com.intellij.util.lang.HashMapZipFile;
import com.intellij.util.lang.ImmutableZipEntry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.GraphConfiguration;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.java.JvmClassNodeBuilder;
import org.jetbrains.jps.dependency.java.Proto;
import org.jetbrains.jps.incremental.dependencies.LibraryDef;
import org.jetbrains.org.objectweb.asm.ClassReader;

final class LibraryNodesBuilder {
    private final GraphConfiguration myGraphConfig;

    LibraryNodesBuilder(GraphConfiguration graphConfig) {
        this.myGraphConfig = graphConfig;
    }

    public Iterable<Node<?, ?>> processLibraryRoot(@NotNull String namespace, NodeSource libRoot) throws IOException {
        if (namespace == null) {
            LibraryNodesBuilder.$$$reportNull$$$0(0);
        }
        if (!LibraryDef.isLibraryPath(libRoot)) {
            return List.of();
        }
        Path jarPath = this.myGraphConfig.getPathMapper().toPath(libRoot);
        HashMapZipFile zipFile = HashMapZipFile.loadIfNotEmpty((Path)jarPath);
        if (zipFile == null) {
            return List.of();
        }
        ArrayList nodes = new ArrayList();
        try (HashMapZipFile hashMapZipFile = zipFile;){
            for (ImmutableZipEntry entry : zipFile.getEntries()) {
                if (entry.isDirectory() || !LibraryDef.isClassFile(entry.getName())) continue;
                LibraryNodesBuilder.addNode(entry.getData(zipFile), entry.getName(), namespace, nodes);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return nodes;
    }

    private static void addNode(byte @NotNull [] classFileData, @NotNull String classFileName, @NotNull String namespace, List<Node<?, ?>> acc) throws IOException {
        if (classFileName == null) {
            LibraryNodesBuilder.$$$reportNull$$$0(1);
        }
        if (namespace == null) {
            LibraryNodesBuilder.$$$reportNull$$$0(2);
        }
        if (classFileData == null) {
            LibraryNodesBuilder.$$$reportNull$$$0(3);
        }
        FailSafeClassReader reader = new FailSafeClassReader(classFileData);
        Node node = JvmClassNodeBuilder.createForLibrary("$" + namespace + "/" + classFileName, (ClassReader)reader).getResult();
        if (JvmClassNodeBuilder.isAbiNode((Proto)((Object)node))) {
            acc.add(node);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFileName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFileData";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/dependencies/LibraryNodesBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processLibraryRoot";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

