/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.IgnoredViewDialog;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileActionGroup;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilePathsNode;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0017J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserIgnoredFilesNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserSpecificFilePathsNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vcs/FilePath;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "canAcceptDrop", "dragBean", "Lcom/intellij/openapi/vcs/changes/ui/ChangeListDragBean;", "acceptDrop", "dragOwner", "Lcom/intellij/openapi/vcs/changes/ChangeListOwner;", "getTextPresentation", "", "getSortWeight", "", "getVcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nChangesBrowserIgnoredFilesNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesBrowserIgnoredFilesNode.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesBrowserIgnoredFilesNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class ChangesBrowserIgnoredFilesNode
extends ChangesBrowserSpecificFilePathsNode<ChangesBrowserNode.Tag> {
    @NotNull
    private final Project project;

    public ChangesBrowserIgnoredFilesNode(@NotNull Project project, @NotNull List<? extends FilePath> files) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        super(ChangesBrowserNode.IGNORED_FILES_TAG, (Collection<FilePath>)files, () -> ChangesBrowserIgnoredFilesNode._init_$lambda$0(project));
        this.project = project;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
        super.render(renderer, selected, expanded, hasFocus);
        if (!this.project.isDisposed() && ChangeListManagerImpl.getInstanceImpl(this.project).isIgnoredInUpdateMode()) {
            this.appendUpdatingState(renderer);
        }
    }

    @Override
    @ApiStatus.Internal
    public boolean canAcceptDrop(@NotNull ChangeListDragBean dragBean) {
        Intrinsics.checkNotNullParameter((Object)dragBean, (String)"dragBean");
        List<FilePath> list = dragBean.getUnversionedFiles();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getUnversionedFiles(...)");
        return !((Collection)list).isEmpty();
    }

    @Override
    @ApiStatus.Internal
    public void acceptDrop(@NotNull ChangeListOwner dragOwner, @NotNull ChangeListDragBean dragBean) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)dragOwner, (String)"dragOwner");
            Intrinsics.checkNotNullParameter((Object)dragBean, (String)"dragBean");
            JComponent jComponent = dragBean.getSourceComponent();
            Tree tree = jComponent instanceof Tree ? (Tree)jComponent : null;
            if (tree == null) {
                return;
            }
            Tree tree2 = tree;
            List<FilePath> list = dragBean.getUnversionedFiles();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getUnversionedFiles(...)");
            AbstractVcs abstractVcs = this.getVcs(list);
            if (abstractVcs == null) {
                return;
            }
            AbstractVcs vcs = abstractVcs;
            IgnoreFileType ignoreFileType = VcsIgnoreManagerImpl.Companion.getInstanceImpl(this.project).findIgnoreFileType(vcs);
            if (ignoreFileType == null) {
                return;
            }
            IgnoreFileType ignoreFileType2 = ignoreFileType;
            IgnoreFileActionGroup ignoreGroup = new IgnoreFileActionGroup(ignoreFileType2);
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)ignoreGroup, DataManager.getInstance().getDataContext((Component)dragBean.getSourceComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
            ListPopup popup = listPopup;
            Rectangle rectangle = tree2.getPathBounds(new TreePath(dragBean.getTargetNode().getPath()));
            if (rectangle == null) break block3;
            Rectangle dropBounds = rectangle;
            boolean bl = false;
            popup.show(new RelativePoint((Component)dragBean.getSourceComponent(), dropBounds.getLocation()));
        }
    }

    @Override
    @Nls
    @NotNull
    public String getTextPresentation() {
        return this.getUserObject().toString();
    }

    @Override
    public int getSortWeight() {
        return 11;
    }

    private final AbstractVcs getVcs(List<? extends FilePath> $this$getVcs) {
        AbstractVcs abstractVcs;
        block1: {
            for (FilePath file : (Iterable)$this$getVcs) {
                boolean bl = false;
                AbstractVcs abstractVcs2 = VcsUtil.getVcsFor((Project)this.project, (FilePath)file);
                if (abstractVcs2 == null) continue;
                abstractVcs = abstractVcs2;
                break block1;
            }
            abstractVcs = null;
        }
        return abstractVcs;
    }

    private static final void _init_$lambda$0(Project $project) {
        if (!$project.isDisposed()) {
            new IgnoredViewDialog($project).show();
        }
    }
}

