/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit.message;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.formatting.LineWrappingUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiFile;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpinnerKt;
import com.intellij.util.DocumentUtil;
import com.intellij.vcs.commit.message.BaseCommitMessageInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\u001c\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J5\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/commit/message/BodyLimitInspection;", "Lcom/intellij/vcs/commit/message/BaseCommitMessageInspection;", "<init>", "()V", "RIGHT_MARGIN", "", "getDisplayName", "", "Lorg/jetbrains/annotations/Nls;", "createOptions", "", "Lcom/intellij/ui/dsl/builder/Panel;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Document;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "canReformat", "reformat", "", "WrapLineQuickFix", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nBodyLimitInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BodyLimitInspection.kt\ncom/intellij/vcs/commit/message/BodyLimitInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,96:1\n1617#2,9:97\n1869#2:106\n1870#2:108\n1626#2:109\n1#3:107\n37#4:110\n36#4,3:111\n*S KotlinDebug\n*F\n+ 1 BodyLimitInspection.kt\ncom/intellij/vcs/commit/message/BodyLimitInspection\n*L\n52#1:97,9\n52#1:106\n52#1:108\n52#1:109\n52#1:107\n56#1:110\n56#1:111,3\n*E\n"})
public final class BodyLimitInspection
extends BaseCommitMessageInspection {
    @JvmField
    public int RIGHT_MARGIN = 72;

    @NotNull
    public String getDisplayName() {
        String string = VcsBundle.message((String)"inspection.BodyLimitInspection.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    public boolean createOptions(@NotNull Panel $this$createOptions, @NotNull Project project, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)$this$createOptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        VcsConfiguration settings = VcsConfiguration.getInstance((Project)project);
        String string = VcsBundle.message((String)"settings.commit.message.right.margin.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createOptions.row(string, arg_0 -> BodyLimitInspection.createOptions$lambda$0(this, arg_0));
        Panel.row$default((Panel)$this$createOptions, null, arg_0 -> BodyLimitInspection.createOptions$lambda$1(settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$createOptions, null, arg_0 -> BodyLimitInspection.createOptions$lambda$2(settings, arg_0), (int)1, null);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull Document document, @NotNull InspectionManager manager, boolean isOnTheFly) {
        void $this$toTypedArray$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        IntRange lines = RangesKt.until((int)1, (int)document.getLineCount());
        Iterable $this$mapNotNull$iv = (Iterable)lines;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ProblemDescriptor it$iv$iv;
            String problemText;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int line = element$iv$iv;
            boolean bl2 = false;
            Object[] objectArray = new Object[]{this.RIGHT_MARGIN};
            Intrinsics.checkNotNullExpressionValue((Object)VcsBundle.message((String)"commit.message.inspection.message.body.lines.should.not.exceed.characters", (Object[])objectArray), (String)"message(...)");
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new WrapLineQuickFix(), new BaseCommitMessageInspection.ReformatCommitMessageQuickFix()};
            if (BaseCommitMessageInspection.checkRightMargin(file, document, manager, isOnTheFly, line, this.RIGHT_MARGIN, problemText, localQuickFixArray) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ProblemDescriptor[0]);
    }

    @Override
    public boolean canReformat(@NotNull Project project, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return this.hasProblems(project, document);
    }

    @Override
    public void reformat(@NotNull Project project, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        new WrapLineQuickFix().doApplyFix(project, document, null);
    }

    private static final Unit createOptions$lambda$0(BodyLimitInspection this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        SpinnerKt.bindIntValue((Cell)Row.spinner$default((Row)$this$row, (IntRange)new IntRange(0, 10000), (int)0, (int)2, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return ((BodyLimitInspection)((Object)this.receiver)).RIGHT_MARGIN;
            }

            public void set(Object value) {
                ((BodyLimitInspection)((Object)this.receiver)).RIGHT_MARGIN = ((Number)value).intValue();
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createOptions$lambda$1(VcsConfiguration $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"settings.commit.message.show.right.margin.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((VcsConfiguration)this.receiver).USE_COMMIT_MESSAGE_MARGIN;
            }

            public void set(Object value) {
                ((VcsConfiguration)this.receiver).USE_COMMIT_MESSAGE_MARGIN = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createOptions$lambda$2(VcsConfiguration $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ApplicationBundle.message((String)"checkbox.wrap.typing.on.right.margin", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((VcsConfiguration)this.receiver).WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN;
            }

            public void set(Object value) {
                ((VcsConfiguration)this.receiver).WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J0\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/commit/message/BodyLimitInspection$WrapLineQuickFix;", "Lcom/intellij/vcs/commit/message/BaseCommitMessageInspection$BaseCommitMessageQuickFix;", "<init>", "(Lcom/intellij/vcs/commit/message/BodyLimitInspection;)V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "doApplyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getBodyRange", "Lcom/intellij/openapi/util/TextRange;", "wrapLines", "editor", "Lcom/intellij/openapi/editor/Editor;", "rightMargin", "", "range", "intellij.platform.vcs.impl"})
    private final class WrapLineQuickFix
    extends BaseCommitMessageInspection.BaseCommitMessageQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = VcsBundle.message((String)"commit.message.intention.family.name.wrap.line", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        public void doApplyFix(@NotNull Project project, @NotNull Document document, @Nullable ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Editor editor = CommitMessage.getEditor(document);
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            TextRange textRange = descriptor != null && descriptor.getLineNumber() >= 0 ? DocumentUtil.getLineTextRange((Document)document, (int)descriptor.getLineNumber()) : this.getBodyRange(document);
            Intrinsics.checkNotNull((Object)textRange);
            TextRange range = textRange;
            if (!range.isEmpty()) {
                this.wrapLines(project, editor2, document, BodyLimitInspection.this.RIGHT_MARGIN, range);
            }
        }

        private final TextRange getBodyRange(Document document) {
            if (document.getLineCount() > 1) {
                TextRange textRange = TextRange.create((int)document.getLineStartOffset(1), (int)document.getTextLength());
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
                return textRange;
            }
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
            return textRange;
        }

        private final void wrapLines(Project project, Editor editor, Document document, int rightMargin, TextRange range) {
            List enabledRanges = CollectionsKt.listOf((Object)TextRange.create((int)0, (int)document.getTextLength()));
            LineWrappingUtil.doWrapLongLinesIfNecessary((Editor)editor, (Project)project, (Document)document, (int)range.getStartOffset(), (int)range.getEndOffset(), (List)enabledRanges, (int)rightMargin);
        }
    }
}

