/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm;

import org.jetbrains.coverage.org.objectweb.asm.ByteVector;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassWriter;
import org.jetbrains.coverage.org.objectweb.asm.ConstantDynamic;
import org.jetbrains.coverage.org.objectweb.asm.Handle;
import org.jetbrains.coverage.org.objectweb.asm.Symbol;
import org.jetbrains.coverage.org.objectweb.asm.Type;

final class SymbolTable {
    final ClassWriter classWriter;
    private final ClassReader sourceClassReader;
    private int majorVersion;
    private String className;
    private int entryCount;
    private Entry[] entries;
    private int constantPoolCount;
    private ByteVector constantPool;
    private int bootstrapMethodCount;
    private ByteVector bootstrapMethods;
    private int typeCount;
    private Entry[] typeTable;

    /*
     * WARNING - void declaration
     */
    SymbolTable(ClassWriter classWriter) {
        void var1_1;
        this.classWriter = var1_1;
        this.sourceClassReader = null;
        this.entries = new Entry[256];
        this.constantPoolCount = 1;
        this.constantPool = new ByteVector();
    }

    /*
     * WARNING - void declaration
     */
    SymbolTable(ClassWriter classWriter, ClassReader classReader) {
        byte itemTag;
        this.classWriter = classWriter;
        this.sourceClassReader = classReader;
        byte[] inputBytes = classReader.classFileBuffer;
        int constantPoolOffset = classReader.getItem(1) - 1;
        int constantPoolLength = classReader.header - constantPoolOffset;
        this.constantPoolCount = classReader.getItemCount();
        this.constantPool = new ByteVector(constantPoolLength);
        this.constantPool.putByteArray(inputBytes, constantPoolOffset, constantPoolLength);
        this.entries = new Entry[this.constantPoolCount << 1];
        char[] charBuffer = new char[classReader.getMaxStringLength()];
        boolean hasBootstrapMethods = false;
        block10: for (int itemIndex = 1; itemIndex < this.constantPoolCount; itemIndex += itemTag == 5 || itemTag == 6 ? 2 : 1) {
            int itemOffset = classReader.getItem(itemIndex);
            itemTag = inputBytes[itemOffset - 1];
            switch (itemTag) {
                case 9: 
                case 10: 
                case 11: {
                    ClassReader classReader2 = classReader;
                    int nameAndTypeItemOffset = classReader2.getItem(classReader2.readUnsignedShort(itemOffset + 2));
                    this.addConstantMemberReference(itemIndex, itemTag, classReader.readClass(itemOffset, charBuffer), classReader.readUTF8(nameAndTypeItemOffset, charBuffer), classReader.readUTF8(nameAndTypeItemOffset + 2, charBuffer));
                    continue block10;
                }
                case 3: 
                case 4: {
                    this.addConstantIntegerOrFloat(itemIndex, itemTag, classReader.readInt(itemOffset));
                    continue block10;
                }
                case 12: {
                    this.addConstantNameAndType(itemIndex, classReader.readUTF8(itemOffset, charBuffer), classReader.readUTF8(itemOffset + 2, charBuffer));
                    continue block10;
                }
                case 5: 
                case 6: {
                    this.addConstantLongOrDouble(itemIndex, itemTag, classReader.readLong(itemOffset));
                    continue block10;
                }
                case 1: {
                    this.addConstantUtf8(itemIndex, classReader.readUtf(itemIndex, charBuffer));
                    continue block10;
                }
                case 15: {
                    ClassReader classReader3 = classReader;
                    int memberRefItemOffset = classReader3.getItem(classReader3.readUnsignedShort(itemOffset + 1));
                    ClassReader classReader4 = classReader;
                    int nameAndTypeItemOffset = classReader4.getItem(classReader4.readUnsignedShort(memberRefItemOffset + 2));
                    this.addConstantMethodHandle(itemIndex, classReader.readByte(itemOffset), classReader.readClass(memberRefItemOffset, charBuffer), classReader.readUTF8(nameAndTypeItemOffset, charBuffer), classReader.readUTF8(nameAndTypeItemOffset + 2, charBuffer));
                    continue block10;
                }
                case 17: 
                case 18: {
                    hasBootstrapMethods = true;
                    ClassReader classReader5 = classReader;
                    int nameAndTypeItemOffset = classReader5.getItem(classReader5.readUnsignedShort(itemOffset + 2));
                    this.addConstantDynamicOrInvokeDynamicReference(itemTag, itemIndex, classReader.readUTF8(nameAndTypeItemOffset, charBuffer), classReader.readUTF8(nameAndTypeItemOffset + 2, charBuffer), classReader.readUnsignedShort(itemOffset));
                    continue block10;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    this.addConstantUtf8Reference(itemIndex, itemTag, classReader.readUTF8(itemOffset, charBuffer));
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (hasBootstrapMethods) {
            void var3_4;
            void var2_2;
            this.copyBootstrapMethods((ClassReader)var2_2, (char[])var3_4);
        }
    }

    private void copyBootstrapMethods(ClassReader classReader, char[] charBuffer) {
        byte[] inputBytes = classReader.classFileBuffer;
        int currentAttributeOffset = classReader.getFirstAttributeOffset();
        for (int i = classReader.readUnsignedShort(currentAttributeOffset - 2); i > 0; --i) {
            String attributeName = classReader.readUTF8(currentAttributeOffset, charBuffer);
            if ("BootstrapMethods".equals(attributeName)) {
                this.bootstrapMethodCount = classReader.readUnsignedShort(currentAttributeOffset + 6);
                break;
            }
            currentAttributeOffset += 6 + classReader.readInt(currentAttributeOffset + 2);
        }
        if (this.bootstrapMethodCount > 0) {
            int bootstrapMethodsOffset = currentAttributeOffset + 8;
            int bootstrapMethodsLength = classReader.readInt(currentAttributeOffset + 2) - 2;
            this.bootstrapMethods = new ByteVector(bootstrapMethodsLength);
            this.bootstrapMethods.putByteArray(inputBytes, bootstrapMethodsOffset, bootstrapMethodsLength);
            int currentOffset = bootstrapMethodsOffset;
            for (int i = 0; i < this.bootstrapMethodCount; ++i) {
                int offset = currentOffset - bootstrapMethodsOffset;
                int bootstrapMethodRef = classReader.readUnsignedShort(currentOffset);
                int numBootstrapArguments = classReader.readUnsignedShort(currentOffset += 2);
                currentOffset += 2;
                int hashCode = classReader.readConst(bootstrapMethodRef, charBuffer).hashCode();
                while (numBootstrapArguments-- > 0) {
                    int bootstrapArgument = classReader.readUnsignedShort(currentOffset);
                    currentOffset += 2;
                    hashCode ^= classReader.readConst(bootstrapArgument, charBuffer).hashCode();
                }
                this.add(new Entry(i, 64, offset, hashCode & Integer.MAX_VALUE));
            }
        }
    }

    final ClassReader getSource() {
        return this.sourceClassReader;
    }

    final int getMajorVersion() {
        return this.majorVersion;
    }

    final String getClassName() {
        return this.className;
    }

    /*
     * WARNING - void declaration
     */
    final int setMajorVersionAndClassName(int majorVersion, String className) {
        void var2_2;
        void var1_1;
        this.majorVersion = var1_1;
        this.className = className;
        return this.addConstantClass((String)var2_2).index;
    }

    final int getConstantPoolCount() {
        return this.constantPoolCount;
    }

    final int getConstantPoolLength() {
        return this.constantPool.length;
    }

    final void putConstantPool(ByteVector output) {
        output.putShort(this.constantPoolCount).putByteArray(this.constantPool.data, 0, this.constantPool.length);
    }

    final int computeBootstrapMethodsSize() {
        if (this.bootstrapMethods != null) {
            this.addConstantUtf8("BootstrapMethods");
            return 8 + this.bootstrapMethods.length;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    final void putBootstrapMethods(ByteVector output) {
        if (this.bootstrapMethods != null) {
            void var1_1;
            var1_1.putShort(this.addConstantUtf8("BootstrapMethods")).putInt(this.bootstrapMethods.length + 2).putShort(this.bootstrapMethodCount).putByteArray(this.bootstrapMethods.data, 0, this.bootstrapMethods.length);
        }
    }

    private Entry get(int hashCode) {
        return this.entries[hashCode % this.entries.length];
    }

    /*
     * WARNING - void declaration
     */
    private Entry put(Entry entry) {
        void var1_1;
        if (this.entryCount > this.entries.length * 3 / 4) {
            int currentCapacity = this.entries.length;
            int newCapacity = (currentCapacity << 1) + 1;
            Entry[] newEntries = new Entry[newCapacity];
            for (int i = currentCapacity - 1; i >= 0; --i) {
                Entry currentEntry = this.entries[i];
                while (currentEntry != null) {
                    int newCurrentEntryIndex = currentEntry.hashCode % newCapacity;
                    Entry nextEntry = currentEntry.next;
                    currentEntry.next = newEntries[newCurrentEntryIndex];
                    newEntries[newCurrentEntryIndex] = currentEntry;
                    currentEntry = nextEntry;
                }
            }
            this.entries = newEntries;
        }
        ++this.entryCount;
        int index = entry.hashCode % this.entries.length;
        entry.next = this.entries[index];
        this.entries[var2_2] = var1_1;
        return this.entries[var2_2];
    }

    /*
     * WARNING - void declaration
     */
    private void add(Entry entry) {
        void var1_1;
        ++this.entryCount;
        int index = entry.hashCode % this.entries.length;
        entry.next = this.entries[index];
        this.entries[var2_2] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstant(Object value) {
        void var1_1;
        Handle handle;
        Type type;
        if (value instanceof Integer) {
            return this.addConstantInteger((Integer)value);
        }
        if (value instanceof Byte) {
            return this.addConstantInteger(((Byte)value).intValue());
        }
        if (value instanceof Character) {
            return this.addConstantInteger(((Character)value).charValue());
        }
        if (value instanceof Short) {
            return this.addConstantInteger(((Short)value).intValue());
        }
        if (value instanceof Boolean) {
            return this.addConstantInteger((Boolean)value != false ? 1 : 0);
        }
        if (value instanceof Float) {
            return this.addConstantFloat(((Float)value).floatValue());
        }
        if (value instanceof Long) {
            return this.addConstantLong((Long)value);
        }
        if (value instanceof Double) {
            return this.addConstantDouble((Double)value);
        }
        if (value instanceof String) {
            return this.addConstantString((String)value);
        }
        if (value instanceof Type) {
            void var2_2;
            type = (Type)value;
            int typeSort = type.getSort();
            if (typeSort == 10) {
                return this.addConstantClass(type.getInternalName());
            }
            if (var2_2 == 11) {
                return this.addConstantMethodType(type.getDescriptor());
            }
            return this.addConstantClass(type.getDescriptor());
        }
        if (type instanceof Handle) {
            handle = (Handle)((Object)type);
            return this.addConstantMethodHandle(handle.getTag(), handle.getOwner(), handle.getName(), handle.getDesc(), handle.isInterface());
        }
        if (handle instanceof ConstantDynamic) {
            ConstantDynamic constantDynamic = (ConstantDynamic)((Object)handle);
            return this.addConstantDynamic(constantDynamic.getName(), constantDynamic.getDescriptor(), constantDynamic.getBootstrapMethod(), var1_1.getBootstrapMethodArgumentsUnsafe());
        }
        throw new IllegalArgumentException("value " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantClass(String value) {
        void var1_1;
        return this.addConstantUtf8Reference(7, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantFieldref(String owner, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addConstantMemberReference(9, (String)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantMethodref(String owner, String name, String descriptor, boolean isInterface) {
        void var3_3;
        void var2_2;
        void var1_1;
        int tag = isInterface ? 11 : 10;
        return this.addConstantMemberReference(tag, (String)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private Entry addConstantMemberReference(int tag, String owner, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        int hashCode = SymbolTable.hash(tag, owner, name, descriptor);
        Entry entry = this.get(hashCode);
        while (entry != null) {
            if (entry.tag == tag && entry.hashCode == hashCode && entry.owner.equals(owner) && entry.name.equals(name) && entry.value.equals(descriptor)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put122(tag, this.addConstantClass((String)owner).index, this.addConstantNameAndType(name, descriptor));
        return this.put(new Entry(this.constantPoolCount++, (int)var1_1, (String)var2_2, (String)var3_3, descriptor, 0L, hashCode));
    }

    /*
     * WARNING - void declaration
     */
    private void addConstantMemberReference(int index, int tag, String owner, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.add(new Entry((int)var1_1, tag, owner, name, descriptor, 0L, SymbolTable.hash((int)var2_2, (String)var3_3, name, descriptor)));
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantString(String value) {
        void var1_1;
        return this.addConstantUtf8Reference(8, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantInteger(int value) {
        void var1_1;
        return this.addConstantIntegerOrFloat(3, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantFloat(float value) {
        void var1_1;
        return this.addConstantIntegerOrFloat(4, Float.floatToRawIntBits((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private Symbol addConstantIntegerOrFloat(int tag, int value) {
        void var3_3;
        void var2_2;
        void var1_1;
        int hashCode = SymbolTable.hash(tag, value);
        Entry entry = this.get(hashCode);
        while (entry != null) {
            if (entry.tag == tag && entry.hashCode == hashCode && entry.data == (long)value) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.putByte(tag).putInt(value);
        return this.put(new Entry(this.constantPoolCount++, (int)var1_1, (long)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private void addConstantIntegerOrFloat(int index, int tag, int value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.add(new Entry((int)var1_1, tag, value, SymbolTable.hash((int)var2_2, (int)var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantLong(long value) {
        void var1_1;
        return this.addConstantLongOrDouble(5, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantDouble(double value) {
        void var1_1;
        return this.addConstantLongOrDouble(6, Double.doubleToRawLongBits((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private Symbol addConstantLongOrDouble(int tag, long value) {
        void var2_2;
        void var1_1;
        int hashCode = SymbolTable.hash(tag, value);
        Entry entry = this.get(hashCode);
        while (entry != null) {
            if (entry.tag == tag && entry.hashCode == hashCode && entry.data == value) {
                return entry;
            }
            entry = entry.next;
        }
        int index = this.constantPoolCount;
        this.constantPool.putByte(tag).putLong(value);
        this.constantPoolCount += 2;
        return this.put(new Entry(index, (int)var1_1, (long)var2_2, hashCode));
    }

    /*
     * WARNING - void declaration
     */
    private void addConstantLongOrDouble(int index, int tag, long value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.add(new Entry((int)var1_1, tag, value, SymbolTable.hash((int)var2_2, (long)var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    final int addConstantNameAndType(String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        int hashCode = SymbolTable.hash(12, name, descriptor);
        Entry entry = this.get(hashCode);
        while (entry != null) {
            if (entry.tag == 12 && entry.hashCode == hashCode && entry.name.equals(name) && entry.value.equals(descriptor)) {
                return entry.index;
            }
            entry = entry.next;
        }
        this.constantPool.put122(12, this.addConstantUtf8(name), this.addConstantUtf8(descriptor));
        return this.put((Entry)new Entry((int)this.constantPoolCount++, (int)12, (String)var1_1, (String)var2_2, (int)var3_3)).index;
    }

    /*
     * WARNING - void declaration
     */
    private void addConstantNameAndType(int index, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.add(new Entry((int)var1_1, 12, name, descriptor, SymbolTable.hash(12, (String)var2_2, (String)var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    final int addConstantUtf8(String value) {
        void var2_2;
        void var1_1;
        int hashCode = SymbolTable.hash(1, value);
        Entry entry = this.get(hashCode);
        while (entry != null) {
            if (entry.tag == 1 && entry.hashCode == hashCode && entry.value.equals(value)) {
                return entry.index;
            }
            entry = entry.next;
        }
        this.constantPool.putByte(1).putUTF8(value);
        return this.put((Entry)new Entry((int)this.constantPoolCount++, (int)1, (String)var1_1, (int)var2_2)).index;
    }

    /*
     * WARNING - void declaration
     */
    private void addConstantUtf8(int index, String value) {
        void var2_2;
        void var1_1;
        this.add(new Entry((int)var1_1, 1, value, SymbolTable.hash(1, (String)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantMethodHandle(int referenceKind, String owner, String name, String descriptor, boolean isInterface) {
        void var1_1;
        void var3_3;
        void var2_2;
        int hashCode = SymbolTable.hash(15, owner, name, descriptor, referenceKind);
        Entry entry = this.get(hashCode);
        while (entry != null) {
            if (entry.tag == 15 && entry.hashCode == hashCode && entry.data == (long)referenceKind && entry.owner.equals(owner) && entry.name.equals(name) && entry.value.equals(descriptor)) {
                return entry;
            }
            entry = entry.next;
        }
        if (referenceKind <= 4) {
            this.constantPool.put112(15, referenceKind, this.addConstantFieldref((String)owner, (String)name, (String)descriptor).index);
        } else {
            this.constantPool.put112(15, referenceKind, this.addConstantMethodref((String)owner, (String)name, (String)descriptor, (boolean)isInterface).index);
        }
        return this.put(new Entry(this.constantPoolCount++, 15, (String)var2_2, (String)var3_3, descriptor, (long)var1_1, hashCode));
    }

    /*
     * WARNING - void declaration
     */
    private void addConstantMethodHandle(int index, int referenceKind, String owner, String name, String descriptor) {
        void var2_2;
        void var3_3;
        void var1_1;
        int hashCode = SymbolTable.hash(15, owner, name, descriptor, referenceKind);
        this.add(new Entry((int)var1_1, 15, (String)var3_3, name, descriptor, (long)var2_2, hashCode));
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantMethodType(String methodDescriptor) {
        void var1_1;
        return this.addConstantUtf8Reference(16, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantDynamic(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        Symbol bootstrapMethod = this.addBootstrapMethod(bootstrapMethodHandle, bootstrapMethodArguments);
        return this.addConstantDynamicOrInvokeDynamicReference(17, (String)var1_1, (String)var2_2, var3_3.index);
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantInvokeDynamic(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        Symbol bootstrapMethod = this.addBootstrapMethod(bootstrapMethodHandle, bootstrapMethodArguments);
        return this.addConstantDynamicOrInvokeDynamicReference(18, (String)var1_1, (String)var2_2, var3_3.index);
    }

    /*
     * WARNING - void declaration
     */
    private Symbol addConstantDynamicOrInvokeDynamicReference(int tag, String name, String descriptor, int bootstrapMethodIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        int hashCode = SymbolTable.hash(tag, name, descriptor, bootstrapMethodIndex);
        Entry entry = this.get(hashCode);
        while (entry != null) {
            if (entry.tag == tag && entry.hashCode == hashCode && entry.data == (long)bootstrapMethodIndex && entry.name.equals(name) && entry.value.equals(descriptor)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put122(tag, bootstrapMethodIndex, this.addConstantNameAndType(name, descriptor));
        return this.put(new Entry(this.constantPoolCount++, (int)var1_1, null, (String)var2_2, (String)var3_3, bootstrapMethodIndex, hashCode));
    }

    /*
     * WARNING - void declaration
     */
    private void addConstantDynamicOrInvokeDynamicReference(int tag, int index, String name, String descriptor, int bootstrapMethodIndex) {
        void var3_3;
        void var1_1;
        void var2_2;
        int hashCode = SymbolTable.hash(tag, name, descriptor, bootstrapMethodIndex);
        this.add(new Entry((int)var2_2, (int)var1_1, null, (String)var3_3, descriptor, bootstrapMethodIndex, hashCode));
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantModule(String moduleName) {
        void var1_1;
        return this.addConstantUtf8Reference(19, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addConstantPackage(String packageName) {
        void var1_1;
        return this.addConstantUtf8Reference(20, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Symbol addConstantUtf8Reference(int tag, String value) {
        void var3_3;
        void var2_2;
        void var1_1;
        int hashCode = SymbolTable.hash(tag, value);
        Entry entry = this.get(hashCode);
        while (entry != null) {
            if (entry.tag == tag && entry.hashCode == hashCode && entry.value.equals(value)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put12(tag, this.addConstantUtf8(value));
        return this.put(new Entry(this.constantPoolCount++, (int)var1_1, (String)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private void addConstantUtf8Reference(int index, int tag, String value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.add(new Entry((int)var1_1, tag, value, SymbolTable.hash((int)var2_2, (String)var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    final Symbol addBootstrapMethod(Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        void var1_2;
        void var2_3;
        void var3_4;
        ByteVector bootstrapMethodsAttribute = this.bootstrapMethods;
        if (bootstrapMethodsAttribute == null) {
            bootstrapMethodsAttribute = this.bootstrapMethods = new ByteVector();
        }
        int numBootstrapArguments = bootstrapMethodArguments.length;
        int[] bootstrapMethodArgumentIndexes = new int[numBootstrapArguments];
        for (int i = 0; i < numBootstrapArguments; ++i) {
            bootstrapMethodArgumentIndexes[i] = this.addConstant((Object)bootstrapMethodArguments[i]).index;
        }
        int bootstrapMethodOffset = bootstrapMethodsAttribute.length;
        bootstrapMethodsAttribute.putShort(this.addConstantMethodHandle((int)bootstrapMethodHandle.getTag(), (String)bootstrapMethodHandle.getOwner(), (String)bootstrapMethodHandle.getName(), (String)bootstrapMethodHandle.getDesc(), (boolean)bootstrapMethodHandle.isInterface()).index);
        bootstrapMethodsAttribute.putShort(numBootstrapArguments);
        for (int i = 0; i < numBootstrapArguments; ++i) {
            bootstrapMethodsAttribute.putShort(bootstrapMethodArgumentIndexes[i]);
        }
        int bootstrapMethodlength = var3_4.length - bootstrapMethodOffset;
        int hashCode = bootstrapMethodHandle.hashCode();
        for (void bootstrapMethodArgument : var2_3) {
            hashCode ^= bootstrapMethodArgument.hashCode();
        }
        hashCode &= Integer.MAX_VALUE;
        return this.addBootstrapMethod(bootstrapMethodOffset, bootstrapMethodlength, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private Symbol addBootstrapMethod(int offset, int length, int hashCode) {
        void var3_3;
        void var1_1;
        byte[] bootstrapMethodsData = this.bootstrapMethods.data;
        Entry entry = this.get(hashCode);
        while (entry != null) {
            if (entry.tag == 64 && entry.hashCode == hashCode) {
                int otherOffset = (int)entry.data;
                boolean isSameBootstrapMethod = true;
                for (int i = 0; i < length; ++i) {
                    if (bootstrapMethodsData[offset + i] == bootstrapMethodsData[otherOffset + i]) continue;
                    isSameBootstrapMethod = false;
                    break;
                }
                if (isSameBootstrapMethod) {
                    this.bootstrapMethods.length = offset;
                    return entry;
                }
            }
            entry = entry.next;
        }
        return this.put(new Entry(this.bootstrapMethodCount++, 64, (long)var1_1, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    final Symbol getType(int typeIndex) {
        void var1_1;
        return this.typeTable[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    final int addType(String value) {
        void var2_2;
        void var1_1;
        int hashCode = SymbolTable.hash(128, value);
        Entry entry = this.get(hashCode);
        while (entry != null) {
            if (entry.tag == 128 && entry.hashCode == hashCode && entry.value.equals(value)) {
                return entry.index;
            }
            entry = entry.next;
        }
        return this.addTypeInternal(new Entry(this.typeCount, 128, (String)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    final int addUninitializedType(String value, int bytecodeOffset) {
        void var3_3;
        void var2_2;
        void var1_1;
        int hashCode = SymbolTable.hash(129, value, bytecodeOffset);
        Entry entry = this.get(hashCode);
        while (entry != null) {
            if (entry.tag == 129 && entry.hashCode == hashCode && entry.data == (long)bytecodeOffset && entry.value.equals(value)) {
                return entry.index;
            }
            entry = entry.next;
        }
        return this.addTypeInternal(new Entry(this.typeCount, 129, (String)var1_1, (long)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    final int addMergedType(int typeTableIndex1, int typeTableIndex2) {
        void var1_3;
        void var2_5;
        int commonSuperTypeIndex;
        long data = typeTableIndex1 < typeTableIndex2 ? (long)typeTableIndex1 | (long)typeTableIndex2 << 32 : (long)typeTableIndex2 | (long)typeTableIndex1 << 32;
        int hashCode = SymbolTable.hash(130, typeTableIndex1 + typeTableIndex2);
        Entry entry = this.get(hashCode);
        while (entry != null) {
            if (entry.tag == 130 && entry.hashCode == hashCode && entry.data == data) {
                return entry.info;
            }
            entry = entry.next;
        }
        String type1 = this.typeTable[typeTableIndex1].value;
        String type2 = this.typeTable[typeTableIndex2].value;
        SymbolTable symbolTable = this;
        this.put((Entry)new Entry((int)this.typeCount, (int)130, (long)var3_6, (int)hashCode)).info = commonSuperTypeIndex = symbolTable.addType(symbolTable.classWriter.getCommonSuperClass(type1, (String)var2_5));
        return (int)var1_3;
    }

    /*
     * WARNING - void declaration
     */
    private int addTypeInternal(Entry entry) {
        void var1_1;
        if (this.typeTable == null) {
            this.typeTable = new Entry[16];
        }
        if (this.typeCount == this.typeTable.length) {
            void var2_2;
            Entry[] newTypeTable = new Entry[2 * this.typeTable.length];
            System.arraycopy(this.typeTable, 0, newTypeTable, 0, this.typeTable.length);
            this.typeTable = var2_2;
        }
        this.typeTable[this.typeCount++] = entry;
        return this.put((Entry)var1_1).index;
    }

    /*
     * WARNING - void declaration
     */
    private static int hash(int tag, int value) {
        void var1_1;
        int n;
        return Integer.MAX_VALUE & n + var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int hash(int tag, long value) {
        void var1_1;
        int n;
        return Integer.MAX_VALUE & n + (int)value + (int)(var1_1 >>> 32);
    }

    /*
     * WARNING - void declaration
     */
    private static int hash(int tag, String value) {
        void var1_1;
        int n;
        return Integer.MAX_VALUE & n + var1_1.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    private static int hash(int tag, String value1, int value2) {
        void var2_2;
        void var1_1;
        int n;
        return Integer.MAX_VALUE & n + var1_1.hashCode() + var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int hash(int tag, String value1, String value2) {
        void var2_2;
        void var1_1;
        int n;
        return Integer.MAX_VALUE & n + var1_1.hashCode() * var2_2.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    private static int hash(int tag, String value1, String value2, int value3) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        return Integer.MAX_VALUE & n + var1_1.hashCode() * var2_2.hashCode() * (var3_3 + true);
    }

    /*
     * WARNING - void declaration
     */
    private static int hash(int tag, String value1, String value2, String value3) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        return Integer.MAX_VALUE & n + var1_1.hashCode() * var2_2.hashCode() * var3_3.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    private static int hash(int tag, String value1, String value2, String value3, int value4) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        return Integer.MAX_VALUE & n + var1_1.hashCode() * var2_2.hashCode() * var3_3.hashCode() * value4;
    }

    private static class Entry
    extends Symbol {
        final int hashCode;
        Entry next;

        /*
         * WARNING - void declaration
         */
        Entry(int index, int tag, String owner, String name, String value, long data, int hashCode) {
            super((int)var1_1, (int)var2_2, (String)var3_3, name, value, data);
            void var3_3;
            void var2_2;
            void var1_1;
            this.hashCode = hashCode;
        }

        /*
         * WARNING - void declaration
         */
        Entry(int index, int tag, String value, int hashCode) {
            super((int)var1_1, (int)var2_2, null, null, (String)var3_3, 0L);
            void var3_3;
            void var2_2;
            void var1_1;
            this.hashCode = hashCode;
        }

        /*
         * WARNING - void declaration
         */
        Entry(int index, int tag, String value, long data, int hashCode) {
            super((int)var1_1, (int)var2_2, null, null, (String)var3_3, data);
            void var3_3;
            void var2_2;
            void var1_1;
            this.hashCode = hashCode;
        }

        /*
         * WARNING - void declaration
         */
        Entry(int index, int tag, String name, String value, int hashCode) {
            super((int)var1_1, (int)var2_2, null, (String)var3_3, value, 0L);
            void var3_3;
            void var2_2;
            void var1_1;
            this.hashCode = hashCode;
        }

        /*
         * WARNING - void declaration
         */
        Entry(int index, int tag, long data, int hashCode) {
            super((int)var1_1, (int)var2_2, null, null, null, (long)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.hashCode = hashCode;
        }
    }
}

