/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import org.keycloak.OAuth2Constants;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.AsymmetricSignatureSignerContext;
import org.keycloak.crypto.ECDSASignatureSignerContext;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.crypto.HashUtils;
import org.keycloak.representations.dpop.DPoP;
import org.keycloak.util.JWKSUtils;

public class DPoPGenerator {
    public static String generateRsaSignedDPoPProof(KeyPair rsaKeyPair, String httpMethod, String endpointURL, String accessToken) {
        JWK jwkRsa = DPoPGenerator.createRsaJwk(rsaKeyPair.getPublic());
        JWSHeader jwsRsaHeader = new JWSHeader(OAuth2Constants.DPOP_DEFAULT_ALGORITHM, "dpop+jwt", jwkRsa.getKeyId(), jwkRsa);
        return new DPoPGenerator().generateSignedDPoPProof(SecretGenerator.getInstance().generateSecureID(), httpMethod, endpointURL, Long.valueOf(Time.currentTime()), jwsRsaHeader, rsaKeyPair.getPrivate(), accessToken);
    }

    private static JWK createRsaJwk(Key publicKey) {
        return JWKBuilder.create().rsa(publicKey, KeyUse.SIG);
    }

    public String generateSignedDPoPProof(String jti, String htm, String htu, Long iat, JWSHeader jwsHeader, PrivateKey privateKey, String accessToken) {
        DPoP dpop = this.generateDPoP(jti, htm, htu, iat, accessToken);
        KeyWrapper keyWrapper = this.getKeyWrapper(jwsHeader, privateKey);
        return this.sign(jwsHeader, dpop, keyWrapper);
    }

    private DPoP generateDPoP(String jti, String htm, String htu, Long iat, String accessToken) {
        DPoP dpop = new DPoP();
        dpop.id(jti);
        dpop.setHttpMethod(htm);
        dpop.setHttpUri(htu);
        dpop.iat(iat);
        if (accessToken != null) {
            dpop.setAccessTokenHash(HashUtils.accessTokenHash(OAuth2Constants.DPOP_DEFAULT_ALGORITHM.toString(), accessToken, true));
        }
        return dpop;
    }

    protected KeyWrapper getKeyWrapper(JWSHeader jwsHeader, PrivateKey privateKey) {
        JWK jwkKey = jwsHeader.getKey();
        if (jwkKey == null) {
            throw new IllegalArgumentException("The JWSHeader does not have key in the 'jwk' claim");
        }
        KeyWrapper keyWrapper = JWKSUtils.getKeyWrapper(jwkKey, true);
        keyWrapper.setPrivateKey(privateKey);
        return keyWrapper;
    }

    private String sign(JWSHeader jwsHeader, DPoP dpop, KeyWrapper keyWrapper) {
        SignatureSignerContext sigCtx = this.createSignatureSignerContext(keyWrapper);
        return new JWSBuilder().header(jwsHeader).jsonContent(dpop).sign(sigCtx);
    }

    private SignatureSignerContext createSignatureSignerContext(KeyWrapper keyWrapper) {
        switch (keyWrapper.getType()) {
            case "EC": {
                return new ECDSASignatureSignerContext(keyWrapper);
            }
            case "RSA": 
            case "OKP": {
                return new AsymmetricSignatureSignerContext(keyWrapper);
            }
        }
        throw new IllegalArgumentException("No signer provider for key algorithm type " + keyWrapper.getType());
    }
}

