/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.memory;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.Constants;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jdk.jfr.consumer.RecordedEvent;

public final class CodeCacheConfigurationHandler
implements RecordedEventHandler {
    private static final String EVENT_NAME = "jdk.CodeCacheConfiguration";
    private static final Attributes ATTR = Attributes.of(Constants.ATTR_MEMORY_TYPE, (Object)"non_heap", Constants.ATTR_MEMORY_POOL, (Object)"CodeCache");
    private final List<AutoCloseable> observables = new ArrayList<AutoCloseable>();
    private volatile long initialSize = 0L;

    public CodeCacheConfigurationHandler(Meter meter) {
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.memory.init").setDescription("Measure of initial memory requested.").setUnit("By").buildWithCallback(measurement -> measurement.record(this.initialSize, ATTR)));
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.MEMORY_POOL_METRICS;
    }

    @Override
    public void accept(RecordedEvent event) {
        if (event.hasField("initialSize")) {
            this.initialSize = event.getLong("initialSize");
        }
    }

    @Override
    public Optional<Duration> getPollingDuration() {
        return Optional.of(Duration.ofSeconds(1L));
    }

    @Override
    public void close() {
        RecordedEventHandler.closeObservables(this.observables);
    }
}

