/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayConstructorFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BottomType;

public class HSQLArrayConstructorFunction
extends ArrayConstructorFunction {
    public HSQLArrayConstructorFunction(boolean list) {
        super(list, true);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        String castTypeName;
        if (returnType != null && this.hasOnlyBottomArguments(arguments)) {
            castTypeName = DdlTypeHelper.getCastTypeName(returnType, walker.getSessionFactory().getTypeConfiguration());
            sqlAppender.append("cast(");
        } else {
            castTypeName = null;
        }
        sqlAppender.append("array");
        int size = arguments.size();
        if (size == 0) {
            sqlAppender.append('[');
        } else {
            int separator = 91;
            for (int i = 0; i < size; ++i) {
                SqlAstNode argument = arguments.get(i);
                sqlAppender.append((char)separator);
                argument.accept(walker);
                separator = 44;
            }
        }
        sqlAppender.append(']');
        if (castTypeName != null) {
            sqlAppender.append(" as ");
            sqlAppender.append(castTypeName);
            sqlAppender.append(')');
        }
    }

    private boolean hasOnlyBottomArguments(List<? extends SqlAstNode> arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            Expression argument = (Expression)arguments.get(i);
            if (argument.getExpressionType().getSingleJdbcMapping() instanceof BottomType) continue;
            return false;
        }
        return !arguments.isEmpty();
    }
}

