/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.connections.jpa.support.EntityManagers;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.partialimport.ClientsPartialImport;
import org.keycloak.partialimport.GroupsPartialImport;
import org.keycloak.partialimport.IdentityProviderMappersPartialImport;
import org.keycloak.partialimport.IdentityProvidersPartialImport;
import org.keycloak.partialimport.PartialImport;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.partialimport.RolesPartialImport;
import org.keycloak.partialimport.UsersPartialImport;
import org.keycloak.representations.idm.PartialImportRepresentation;

public class PartialImportManager {
    private final List<PartialImport> partialImports = new ArrayList<PartialImport>();
    private final PartialImportRepresentation rep;
    private final KeycloakSession session;
    private final RealmModel realm;

    public PartialImportManager(PartialImportRepresentation rep, KeycloakSession session, RealmModel realm) {
        this.rep = rep;
        this.session = session;
        this.realm = realm;
        this.partialImports.add(new ClientsPartialImport());
        this.partialImports.add(new RolesPartialImport());
        this.partialImports.add(new IdentityProvidersPartialImport());
        this.partialImports.add(new IdentityProviderMappersPartialImport());
        this.partialImports.add(new GroupsPartialImport());
        this.partialImports.add(new UsersPartialImport());
    }

    public PartialImportResults saveResources() {
        PartialImportResults results = new PartialImportResults();
        for (PartialImport partialImport : this.partialImports) {
            partialImport.prepare(this.rep, this.realm, this.session);
        }
        for (PartialImport partialImport : this.partialImports) {
            partialImport.removeOverwrites(this.realm, this.session);
            EntityManagers.flush((KeycloakSession)this.session, (boolean)false);
            results.addAllResults(partialImport.doImport(this.rep, this.realm, this.session));
        }
        return results;
    }
}

