/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import java.util.List;
import java.util.Optional;
import org.keycloak.config.HealthOptions;
import org.keycloak.config.HttpOptions;
import org.keycloak.config.ManagementOptions;
import org.keycloak.config.MetricsOptions;
import org.keycloak.config.OpenApiOptions;
import org.keycloak.config.Option;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.HttpPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapperGrouping;

public class ManagementPropertyMappers
implements PropertyMapperGrouping {
    private static final String HTTP_MANAGEMENT_SCHEME_IS_INHERITED = "http-management-scheme is inherited";

    public List<PropertyMapper<?>> getPropertyMappers() {
        return List.of(PropertyMapper.fromOption(ManagementOptions.HTTP_MANAGEMENT_ENABLED).to("quarkus.management.enabled").transformer((val, ctx) -> ManagementPropertyMappers.managementEnabledTransformer()).build(), PropertyMapper.fromOption(ManagementOptions.HTTP_MANAGEMENT_HEALTH_ENABLED).to("quarkus.smallrye-health.management.enabled").isEnabled(() -> Configuration.isTrue((Option<Boolean>)HealthOptions.HEALTH_ENABLED), "health is enabled").build(), PropertyMapper.fromOption(ManagementOptions.LEGACY_OBSERVABILITY_INTERFACE).build(), PropertyMapper.fromOption(ManagementOptions.HTTP_MANAGEMENT_RELATIVE_PATH).mapFrom(HttpOptions.HTTP_RELATIVE_PATH).to("quarkus.management.root-path").paramLabel("path").build(), PropertyMapper.fromOption(ManagementOptions.HTTP_MANAGEMENT_PORT).to("quarkus.management.port").paramLabel("port").build(), PropertyMapper.fromOption(ManagementOptions.HTTP_MANAGEMENT_HOST).mapFrom(HttpOptions.HTTP_HOST).to("quarkus.management.host").paramLabel("host").build(), PropertyMapper.fromOption(ManagementOptions.HTTP_MANAGEMENT_SCHEME).paramLabel("scheme").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_CLIENT_AUTH).mapFrom(HttpOptions.HTTPS_CLIENT_AUTH).to("quarkus.management.ssl.client-auth").paramLabel("auth").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_CIPHER_SUITES).isEnabled(ManagementPropertyMappers::isInheritedScheme, HTTP_MANAGEMENT_SCHEME_IS_INHERITED).mapFrom(HttpOptions.HTTPS_CIPHER_SUITES).to("quarkus.management.ssl.cipher-suites").paramLabel("ciphers").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_PROTOCOLS).isEnabled(ManagementPropertyMappers::isInheritedScheme, HTTP_MANAGEMENT_SCHEME_IS_INHERITED).mapFrom(HttpOptions.HTTPS_PROTOCOLS).to("quarkus.management.ssl.protocols").paramLabel("protocols").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_CERTIFICATES_RELOAD_PERIOD).isEnabled(ManagementPropertyMappers::isInheritedScheme, HTTP_MANAGEMENT_SCHEME_IS_INHERITED).mapFrom(HttpOptions.HTTPS_CERTIFICATES_RELOAD_PERIOD).to("quarkus.management.ssl.certificate.reload-period").transformer(HttpPropertyMappers::transformNegativeReloadPeriod).paramLabel("reload period").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_CERTIFICATE_FILE).isEnabled(ManagementPropertyMappers::isInheritedScheme, HTTP_MANAGEMENT_SCHEME_IS_INHERITED).mapFrom(HttpOptions.HTTPS_CERTIFICATE_FILE).to("quarkus.management.ssl.certificate.files").paramLabel("file").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_CERTIFICATE_KEY_FILE).isEnabled(ManagementPropertyMappers::isInheritedScheme, HTTP_MANAGEMENT_SCHEME_IS_INHERITED).mapFrom(HttpOptions.HTTPS_CERTIFICATE_KEY_FILE).to("quarkus.management.ssl.certificate.key-files").paramLabel("file").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_KEY_STORE_FILE).isEnabled(ManagementPropertyMappers::isInheritedScheme, HTTP_MANAGEMENT_SCHEME_IS_INHERITED).mapFrom(HttpOptions.HTTPS_KEY_STORE_FILE).to("quarkus.management.ssl.certificate.key-store-file").paramLabel("file").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_KEY_STORE_PASSWORD).isEnabled(ManagementPropertyMappers::isInheritedScheme, HTTP_MANAGEMENT_SCHEME_IS_INHERITED).mapFrom(HttpOptions.HTTPS_KEY_STORE_PASSWORD).to("quarkus.management.ssl.certificate.key-store-password").paramLabel("password").isMasked(true).build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_KEY_STORE_TYPE).isEnabled(ManagementPropertyMappers::isInheritedScheme, HTTP_MANAGEMENT_SCHEME_IS_INHERITED).mapFrom(HttpOptions.HTTPS_KEY_STORE_TYPE).to("quarkus.management.ssl.certificate.key-store-file-type").paramLabel("type").build());
    }

    public static boolean isManagementEnabled() {
        if (Configuration.isTrue((Option<Boolean>)ManagementOptions.LEGACY_OBSERVABILITY_INTERFACE)) {
            return false;
        }
        return Configuration.isTrue((Option<Boolean>)HealthOptions.HEALTH_ENABLED) && Configuration.isTrue((Option<Boolean>)ManagementOptions.HTTP_MANAGEMENT_HEALTH_ENABLED) || Configuration.isTrue((Option<Boolean>)MetricsOptions.METRICS_ENABLED) || Configuration.isTrue((Option<Boolean>)OpenApiOptions.OPENAPI_ENABLED);
    }

    private static String managementEnabledTransformer() {
        return Boolean.toString(ManagementPropertyMappers.isManagementEnabled());
    }

    public static boolean isInheritedScheme() {
        return !ManagementOptions.Scheme.http.name().equals(Configuration.getKcConfigValue(ManagementOptions.HTTP_MANAGEMENT_SCHEME.getKey()).getValue());
    }

    public static boolean isManagementTlsEnabled() {
        if (ManagementPropertyMappers.isInheritedScheme()) {
            Optional<String> key = Configuration.getOptionalKcValue(ManagementOptions.HTTPS_MANAGEMENT_CERTIFICATE_KEY_FILE.getKey());
            Optional<String> cert = Configuration.getOptionalKcValue(ManagementOptions.HTTPS_MANAGEMENT_CERTIFICATE_FILE.getKey());
            if (key.isPresent() && cert.isPresent()) {
                return true;
            }
            Optional<String> keystore = Configuration.getOptionalKcValue(ManagementOptions.HTTPS_MANAGEMENT_KEY_STORE_FILE.getKey());
            return keystore.isPresent();
        }
        return false;
    }
}

