/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.util.Iterator;
import java.util.function.Consumer;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.InitializerProducerBuilder;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.type.CollectionType;

public class CustomCollectionTypeSemantics<CE, E>
implements CollectionSemantics<CE, E> {
    private final CollectionType collectionType;

    public CustomCollectionTypeSemantics(CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return this.collectionType.getCollectionClassification();
    }

    @Override
    public Class<?> getCollectionJavaType() {
        return this.collectionType.getReturnedClass();
    }

    @Override
    public CE instantiateRaw(int anticipatedSize, CollectionPersister collectionDescriptor) {
        return (CE)this.collectionType.instantiate(anticipatedSize);
    }

    @Override
    public Iterator<E> getElementIterator(CE rawCollection) {
        return this.collectionType.getElementsIterator(rawCollection);
    }

    @Override
    public void visitElements(CE rawCollection, Consumer<? super E> action) {
        this.getElementIterator(rawCollection).forEachRemaining(action);
    }

    @Override
    public CollectionInitializerProducer createInitializerProducer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParent fetchParent, boolean selected, String resultVariable, Fetch indexFetch, Fetch elementFetch, DomainResultCreationState creationState) {
        return InitializerProducerBuilder.createCollectionTypeWrapperInitializerProducer(navigablePath, attributeMapping, this.getCollectionClassification(), fetchParent, selected, indexFetch, elementFetch, creationState);
    }

    @Override
    public PersistentCollection<E> instantiateWrapper(Object key, CollectionPersister collectionDescriptor, SharedSessionContractImplementor session) {
        return this.collectionType.instantiate(session, collectionDescriptor, key);
    }

    @Override
    public PersistentCollection<E> wrap(CE rawCollection, CollectionPersister collectionDescriptor, SharedSessionContractImplementor session) {
        return this.collectionType.wrap(session, rawCollection);
    }
}

