/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointSubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifiedAccessEndpointRdsOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerifiedAccessEndpointRdsOptions> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(VerifiedAccessEndpointRdsOptions.getter(VerifiedAccessEndpointRdsOptions::protocolAsString)).setter(VerifiedAccessEndpointRdsOptions.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("protocol").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(VerifiedAccessEndpointRdsOptions.getter(VerifiedAccessEndpointRdsOptions::port)).setter(VerifiedAccessEndpointRdsOptions.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").unmarshallLocationName("port").build()}).build();
    private static final SdkField<String> RDS_DB_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RdsDbInstanceArn").getter(VerifiedAccessEndpointRdsOptions.getter(VerifiedAccessEndpointRdsOptions::rdsDbInstanceArn)).setter(VerifiedAccessEndpointRdsOptions.setter(Builder::rdsDbInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbInstanceArn").unmarshallLocationName("rdsDbInstanceArn").build()}).build();
    private static final SdkField<String> RDS_DB_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RdsDbClusterArn").getter(VerifiedAccessEndpointRdsOptions.getter(VerifiedAccessEndpointRdsOptions::rdsDbClusterArn)).setter(VerifiedAccessEndpointRdsOptions.setter(Builder::rdsDbClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbClusterArn").unmarshallLocationName("rdsDbClusterArn").build()}).build();
    private static final SdkField<String> RDS_DB_PROXY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RdsDbProxyArn").getter(VerifiedAccessEndpointRdsOptions.getter(VerifiedAccessEndpointRdsOptions::rdsDbProxyArn)).setter(VerifiedAccessEndpointRdsOptions.setter(Builder::rdsDbProxyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbProxyArn").unmarshallLocationName("rdsDbProxyArn").build()}).build();
    private static final SdkField<String> RDS_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RdsEndpoint").getter(VerifiedAccessEndpointRdsOptions.getter(VerifiedAccessEndpointRdsOptions::rdsEndpoint)).setter(VerifiedAccessEndpointRdsOptions.setter(Builder::rdsEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsEndpoint").unmarshallLocationName("rdsEndpoint").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(VerifiedAccessEndpointRdsOptions.getter(VerifiedAccessEndpointRdsOptions::subnetIds)).setter(VerifiedAccessEndpointRdsOptions.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdSet").unmarshallLocationName("subnetIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, PORT_FIELD, RDS_DB_INSTANCE_ARN_FIELD, RDS_DB_CLUSTER_ARN_FIELD, RDS_DB_PROXY_ARN_FIELD, RDS_ENDPOINT_FIELD, SUBNET_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VerifiedAccessEndpointRdsOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String protocol;
    private final Integer port;
    private final String rdsDbInstanceArn;
    private final String rdsDbClusterArn;
    private final String rdsDbProxyArn;
    private final String rdsEndpoint;
    private final List<String> subnetIds;

    private VerifiedAccessEndpointRdsOptions(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.rdsDbInstanceArn = builder.rdsDbInstanceArn;
        this.rdsDbClusterArn = builder.rdsDbClusterArn;
        this.rdsDbProxyArn = builder.rdsDbProxyArn;
        this.rdsEndpoint = builder.rdsEndpoint;
        this.subnetIds = builder.subnetIds;
    }

    public final VerifiedAccessEndpointProtocol protocol() {
        return VerifiedAccessEndpointProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer port() {
        return this.port;
    }

    public final String rdsDbInstanceArn() {
        return this.rdsDbInstanceArn;
    }

    public final String rdsDbClusterArn() {
        return this.rdsDbClusterArn;
    }

    public final String rdsDbProxyArn() {
        return this.rdsDbProxyArn;
    }

    public final String rdsEndpoint() {
        return this.rdsEndpoint;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbProxyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessEndpointRdsOptions)) {
            return false;
        }
        VerifiedAccessEndpointRdsOptions other = (VerifiedAccessEndpointRdsOptions)obj;
        return Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.rdsDbInstanceArn(), other.rdsDbInstanceArn()) && Objects.equals(this.rdsDbClusterArn(), other.rdsDbClusterArn()) && Objects.equals(this.rdsDbProxyArn(), other.rdsDbProxyArn()) && Objects.equals(this.rdsEndpoint(), other.rdsEndpoint()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds());
    }

    public final String toString() {
        return ToString.builder((String)"VerifiedAccessEndpointRdsOptions").add("Protocol", (Object)this.protocolAsString()).add("Port", (Object)this.port()).add("RdsDbInstanceArn", (Object)this.rdsDbInstanceArn()).add("RdsDbClusterArn", (Object)this.rdsDbClusterArn()).add("RdsDbProxyArn", (Object)this.rdsDbProxyArn()).add("RdsEndpoint", (Object)this.rdsEndpoint()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "RdsDbInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.rdsDbInstanceArn()));
            }
            case "RdsDbClusterArn": {
                return Optional.ofNullable(clazz.cast(this.rdsDbClusterArn()));
            }
            case "RdsDbProxyArn": {
                return Optional.ofNullable(clazz.cast(this.rdsDbProxyArn()));
            }
            case "RdsEndpoint": {
                return Optional.ofNullable(clazz.cast(this.rdsEndpoint()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("RdsDbInstanceArn", RDS_DB_INSTANCE_ARN_FIELD);
        map.put("RdsDbClusterArn", RDS_DB_CLUSTER_ARN_FIELD);
        map.put("RdsDbProxyArn", RDS_DB_PROXY_ARN_FIELD);
        map.put("RdsEndpoint", RDS_ENDPOINT_FIELD);
        map.put("SubnetIdSet", SUBNET_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessEndpointRdsOptions, T> g) {
        return obj -> g.apply((VerifiedAccessEndpointRdsOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private Integer port;
        private String rdsDbInstanceArn;
        private String rdsDbClusterArn;
        private String rdsDbProxyArn;
        private String rdsEndpoint;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessEndpointRdsOptions model) {
            this.protocol(model.protocol);
            this.port(model.port);
            this.rdsDbInstanceArn(model.rdsDbInstanceArn);
            this.rdsDbClusterArn(model.rdsDbClusterArn);
            this.rdsDbProxyArn(model.rdsDbProxyArn);
            this.rdsEndpoint(model.rdsEndpoint);
            this.subnetIds(model.subnetIds);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(VerifiedAccessEndpointProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getRdsDbInstanceArn() {
            return this.rdsDbInstanceArn;
        }

        public final void setRdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
        }

        @Override
        public final Builder rdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
            return this;
        }

        public final String getRdsDbClusterArn() {
            return this.rdsDbClusterArn;
        }

        public final void setRdsDbClusterArn(String rdsDbClusterArn) {
            this.rdsDbClusterArn = rdsDbClusterArn;
        }

        @Override
        public final Builder rdsDbClusterArn(String rdsDbClusterArn) {
            this.rdsDbClusterArn = rdsDbClusterArn;
            return this;
        }

        public final String getRdsDbProxyArn() {
            return this.rdsDbProxyArn;
        }

        public final void setRdsDbProxyArn(String rdsDbProxyArn) {
            this.rdsDbProxyArn = rdsDbProxyArn;
        }

        @Override
        public final Builder rdsDbProxyArn(String rdsDbProxyArn) {
            this.rdsDbProxyArn = rdsDbProxyArn;
            return this;
        }

        public final String getRdsEndpoint() {
            return this.rdsEndpoint;
        }

        public final void setRdsEndpoint(String rdsEndpoint) {
            this.rdsEndpoint = rdsEndpoint;
        }

        @Override
        public final Builder rdsEndpoint(String rdsEndpoint) {
            this.rdsEndpoint = rdsEndpoint;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = VerifiedAccessEndpointSubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = VerifiedAccessEndpointSubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public VerifiedAccessEndpointRdsOptions build() {
            return new VerifiedAccessEndpointRdsOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerifiedAccessEndpointRdsOptions> {
        public Builder protocol(String var1);

        public Builder protocol(VerifiedAccessEndpointProtocol var1);

        public Builder port(Integer var1);

        public Builder rdsDbInstanceArn(String var1);

        public Builder rdsDbClusterArn(String var1);

        public Builder rdsDbProxyArn(String var1);

        public Builder rdsEndpoint(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);
    }
}

