/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.Map;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.ParseOption;
import org.scilab.forge.jlatexmath.RotateBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;

public class RotateAtom
extends Atom {
    private Atom base;
    private double angle;
    private int option = -1;
    private int xunit;
    private int yunit;
    private float x;
    private float y;

    public RotateAtom(Atom base, String angle, String option) {
        this.type = base.type;
        this.base = base;
        this.angle = Double.parseDouble(angle);
        this.option = RotateBox.getOrigin(option);
    }

    public RotateAtom(Atom base, double angle, String option) {
        this.type = base.type;
        this.base = base;
        this.angle = angle;
        Map<String, String> map = ParseOption.parseMap(option);
        if (map.containsKey("origin")) {
            this.option = RotateBox.getOrigin(map.get("origin"));
        } else {
            if (map.containsKey("x")) {
                float[] xinfo = SpaceAtom.getLength(map.get("x"));
                this.xunit = (int)xinfo[0];
                this.x = xinfo[1];
            } else {
                this.xunit = 3;
                this.x = 0.0f;
            }
            if (map.containsKey("y")) {
                float[] yinfo = SpaceAtom.getLength(map.get("y"));
                this.yunit = (int)yinfo[0];
                this.y = yinfo[1];
            } else {
                this.yunit = 3;
                this.y = 0.0f;
            }
        }
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        if (this.option != -1) {
            return new RotateBox(this.base.createBox(env), this.angle, this.option);
        }
        return new RotateBox(this.base.createBox(env), this.angle, this.x * SpaceAtom.getFactor(this.xunit, env), this.y * SpaceAtom.getFactor(this.yunit, env));
    }
}

