/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.intermediate;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class NeighborsProcessor
implements ILayoutProcessor<TGraph> {
    private int numberOfNodes;

    @Override
    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Processor set neighbors", 1.0f);
        this.numberOfNodes = tGraph.getNodes().isEmpty() ? 1 : tGraph.getNodes().size();
        TNode root = null;
        Iterator<TNode> it = tGraph.getNodes().iterator();
        while (root == null && it.hasNext()) {
            TNode tNode = it.next();
            if (!tNode.getProperty(InternalProperties.ROOT).booleanValue()) continue;
            root = tNode;
        }
        if (root != null) {
            this.setNeighbors(root.getChildren(), progressMonitor);
        }
        progressMonitor.done();
    }

    private void setNeighbors(Iterable<TNode> currentLevel, IElkProgressMonitor progressMonitor) {
        if (!Iterables.isEmpty(currentLevel)) {
            IElkProgressMonitor sT = progressMonitor.subTask(Iterables.size(currentLevel) / this.numberOfNodes);
            sT.begin("Set neighbors in level", 1.0f);
            Iterable<TNode> nextLevel = new Iterable<TNode>(){

                @Override
                public Iterator<TNode> iterator() {
                    return Collections.emptyIterator();
                }
            };
            TNode lN = null;
            for (TNode cN : currentLevel) {
                nextLevel = Iterables.concat(nextLevel, cN.getChildren());
                if (lN != null) {
                    lN.setProperty(InternalProperties.RIGHTNEIGHBOR, cN);
                    cN.setProperty(InternalProperties.LEFTNEIGHBOR, lN);
                    if (cN.getParent() == lN.getParent()) {
                        lN.setProperty(InternalProperties.RIGHTSIBLING, cN);
                        cN.setProperty(InternalProperties.LEFTSIBLING, lN);
                    }
                }
                lN = cN;
            }
            sT.done();
            this.setNeighbors(nextLevel, progressMonitor);
        }
    }
}

