/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.jetbrains.python.psi.PyFunction;

public final class PyOverridingMethodsSearch
extends ExtensibleQueryFactory<PyFunction, SearchParameters> {
    public static final PyOverridingMethodsSearch INSTANCE = new PyOverridingMethodsSearch();

    private PyOverridingMethodsSearch() {
        super("Pythonid");
    }

    public static Query<PyFunction> search(PyFunction function, boolean checkDeep) {
        if (function.getContainingClass() == null) {
            return EmptyQuery.getEmptyQuery();
        }
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(function, checkDeep));
    }

    public static class SearchParameters {
        private final PyFunction myFunction;
        private final boolean myCheckDeep;

        public SearchParameters(PyFunction function, boolean checkDeep) {
            this.myFunction = function;
            this.myCheckDeep = checkDeep;
        }

        public PyFunction getFunction() {
            return this.myFunction;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }
    }
}

