/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.EnumSet;
import java.util.Set;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.TablePointer;
import schemacrawler.schema.ActionOrientationType;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.Table;
import schemacrawler.schema.Trigger;

class MutableTrigger
extends AbstractDependantObject<Table>
implements Trigger {
    private static final long serialVersionUID = -1619291073229701764L;
    private final StringBuffer actionCondition;
    private final StringBuffer actionStatement;
    private int actionOrder;
    private ActionOrientationType actionOrientation;
    private ConditionTimingType conditionTiming;
    private final Set<EventManipulationType> eventManipulationType = EnumSet.noneOf(EventManipulationType.class);

    MutableTrigger(Table parent, String name) {
        super(new TablePointer(parent), name);
        this.actionOrientation = ActionOrientationType.unknown;
        this.conditionTiming = ConditionTimingType.unknown;
        this.actionCondition = new StringBuffer();
        this.actionStatement = new StringBuffer();
    }

    @Override
    public String getActionCondition() {
        return this.actionCondition.toString();
    }

    @Override
    public int getActionOrder() {
        return this.actionOrder;
    }

    @Override
    public ActionOrientationType getActionOrientation() {
        return this.actionOrientation;
    }

    @Override
    public String getActionStatement() {
        return this.actionStatement.toString();
    }

    @Override
    public ConditionTimingType getConditionTiming() {
        return this.conditionTiming;
    }

    @Override
    public Set<EventManipulationType> getEventManipulationTypes() {
        return EnumSet.copyOf(this.eventManipulationType);
    }

    void appendActionCondition(String actionCondition) {
        if (actionCondition != null) {
            this.actionCondition.append(actionCondition);
        }
    }

    void appendActionStatement(String actionStatement) {
        if (actionStatement != null) {
            this.actionStatement.append(actionStatement);
        }
    }

    void setActionOrder(int actionOrder) {
        this.actionOrder = actionOrder;
    }

    void setActionOrientation(ActionOrientationType actionOrientation) {
        this.actionOrientation = actionOrientation;
    }

    void setConditionTiming(ConditionTimingType conditionTiming) {
        this.conditionTiming = conditionTiming;
    }

    void setEventManipulationTypes(Set<EventManipulationType> eventManipulationTypes) {
        if (eventManipulationTypes == null) {
            this.eventManipulationType.add(EventManipulationType.unknown);
        } else {
            this.eventManipulationType.addAll(eventManipulationTypes);
        }
    }
}

