/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Table;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import us.fatehi.utility.Multimap;
import us.fatehi.utility.Utility;
import us.fatehi.utility.property.PropertyName;

class LinterTableWithIncrementingColumns
extends BaseLinter {
    LinterTableWithIncrementingColumns(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
    }

    @Override
    public String getSummary() {
        return "incrementing columns";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        Multimap<String, IncrementingColumn> incrementingColumns = this.findIncrementingColumns(this.getColumns(table));
        for (List incrementingColumnsList : incrementingColumns.values()) {
            this.addIncrementingColumnsLints(table, incrementingColumnsList);
        }
    }

    private void addIncrementingColumnsLints(Table table, List<IncrementingColumn> incrementingColumnsList) {
        int minIncrement = Integer.MAX_VALUE;
        int maxIncrement = Integer.MIN_VALUE;
        ArrayList<Object> incrementingColumns = new ArrayList<Object>(incrementingColumnsList.size());
        for (int i = 0; i < incrementingColumnsList.size(); ++i) {
            IncrementingColumn incrementingColumn = incrementingColumnsList.get(i);
            incrementingColumns.add(i, incrementingColumn.column());
            minIncrement = Math.min(minIncrement, incrementingColumn.columnIncrement());
            maxIncrement = Math.max(maxIncrement, incrementingColumn.columnIncrement());
        }
        incrementingColumns.sort(Comparator.naturalOrder());
        this.addTableLint(table, this.getSummary(), incrementingColumns);
        if (maxIncrement - minIncrement + 1 != incrementingColumnsList.size()) {
            this.addTableLint(table, "incrementing columns are not consecutive", incrementingColumns);
        }
        ColumnDataType columnDataType = ((Column)incrementingColumns.get(0)).getColumnDataType();
        int columnSize = ((Column)incrementingColumns.get(0)).getSize();
        for (int i = 1; i < incrementingColumns.size(); ++i) {
            if (columnDataType.equals(((Column)incrementingColumns.get(i)).getColumnDataType()) && columnSize == ((Column)incrementingColumns.get(i)).getSize()) continue;
            this.addTableLint(table, "incrementing columns don't have the same data-type", incrementingColumns);
            break;
        }
    }

    private Multimap<String, IncrementingColumn> findIncrementingColumns(List<Column> columns) {
        if (columns == null || columns.size() <= 1) {
            return new Multimap();
        }
        Pattern pattern = Pattern.compile("(.*[^0-9])([0-9]+)");
        HashMap<String, Integer> incrementingColumnsMap = new HashMap<String, Integer>();
        for (Column column : columns) {
            String columnName = Utility.convertForComparison((String)column.getName());
            incrementingColumnsMap.put(columnName, 1);
            Matcher matcher = pattern.matcher(columnName);
            if (!matcher.matches()) continue;
            String columnNameBase = matcher.group(1);
            if (incrementingColumnsMap.containsKey(columnNameBase)) {
                incrementingColumnsMap.put(columnNameBase, (Integer)incrementingColumnsMap.get(columnNameBase) + 1);
                continue;
            }
            incrementingColumnsMap.put(columnNameBase, 1);
        }
        Iterator columnCounts = incrementingColumnsMap.entrySet().iterator();
        while (columnCounts.hasNext()) {
            Map.Entry columnCount = columnCounts.next();
            if ((Integer)columnCount.getValue() != 1) continue;
            columnCounts.remove();
        }
        Multimap incrementingColumns = new Multimap();
        for (Column column : columns) {
            Matcher matcher;
            String columnName = Utility.convertForComparison((String)column.getName());
            if (incrementingColumnsMap.containsKey(columnName)) {
                incrementingColumns.add((Object)columnName, (Object)new IncrementingColumn("0", column));
            }
            if (!(matcher = pattern.matcher(columnName)).matches()) continue;
            String columnNameBase = matcher.group(1);
            String columnIncrement = matcher.group(2);
            if (!incrementingColumnsMap.containsKey(columnNameBase)) continue;
            incrementingColumns.add((Object)columnNameBase, (Object)new IncrementingColumn(columnIncrement, column));
        }
        return incrementingColumns;
    }

    private record IncrementingColumn(int columnIncrement, Column column) {
        public IncrementingColumn(String columnIncrement, Column column) {
            this(IncrementingColumn.parse(columnIncrement), column);
        }

        private static int parse(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
    }
}

