/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.DD;

public class CGAlgorithmsDD {
    private static final double DP_SAFE_EPSILON = 1.0E-15;

    private CGAlgorithmsDD() {
    }

    public static int orientationIndex(Coordinate p1, Coordinate p2, Coordinate q) {
        return CGAlgorithmsDD.orientationIndex(p1.x, p1.y, p2.x, p2.y, q.x, q.y);
    }

    public static int orientationIndex(double p1x, double p1y, double p2x, double p2y, double qx, double qy) {
        int index = CGAlgorithmsDD.orientationIndexFilter(p1x, p1y, p2x, p2y, qx, qy);
        if (index <= 1) {
            return index;
        }
        DD dx1 = DD.valueOf(p2x).selfAdd(-p1x);
        DD dy1 = DD.valueOf(p2y).selfAdd(-p1y);
        DD dx2 = DD.valueOf(qx).selfAdd(-p2x);
        DD dy2 = DD.valueOf(qy).selfAdd(-p2y);
        return dx1.selfMultiply(dy2).selfSubtract(dy1.selfMultiply(dx2)).signum();
    }

    public static int signOfDet2x2(DD x1, DD y1, DD x2, DD y2) {
        DD det = x1.multiply(y2).selfSubtract(y1.multiply(x2));
        return det.signum();
    }

    public static int signOfDet2x2(double dx1, double dy1, double dx2, double dy2) {
        DD x1 = DD.valueOf(dx1);
        DD y1 = DD.valueOf(dy1);
        DD x2 = DD.valueOf(dx2);
        DD y2 = DD.valueOf(dy2);
        DD det = x1.multiply(y2).selfSubtract(y1.multiply(x2));
        return det.signum();
    }

    private static int orientationIndexFilter(double pax, double pay, double pbx, double pby, double pcx, double pcy) {
        double detsum;
        double detleft = (pax - pcx) * (pby - pcy);
        double detright = (pay - pcy) * (pbx - pcx);
        double det = detleft - detright;
        if (detleft > 0.0) {
            if (detright <= 0.0) {
                return CGAlgorithmsDD.signum(det);
            }
            detsum = detleft + detright;
        } else if (detleft < 0.0) {
            if (detright >= 0.0) {
                return CGAlgorithmsDD.signum(det);
            }
            detsum = -detleft - detright;
        } else {
            return CGAlgorithmsDD.signum(det);
        }
        double errbound = 1.0E-15 * detsum;
        if (det >= errbound || -det >= errbound) {
            return CGAlgorithmsDD.signum(det);
        }
        return 2;
    }

    private static int signum(double x) {
        if (x > 0.0) {
            return 1;
        }
        if (x < 0.0) {
            return -1;
        }
        return 0;
    }

    public static Coordinate intersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        DD px = new DD(p1.y).selfSubtract(p2.y);
        DD py = new DD(p2.x).selfSubtract(p1.x);
        DD pw = new DD(p1.x).selfMultiply(p2.y).selfSubtract(new DD(p2.x).selfMultiply(p1.y));
        DD qx = new DD(q1.y).selfSubtract(q2.y);
        DD qy = new DD(q2.x).selfSubtract(q1.x);
        DD qw = new DD(q1.x).selfMultiply(q2.y).selfSubtract(new DD(q2.x).selfMultiply(q1.y));
        DD x = py.multiply(qw).selfSubtract(qy.multiply(pw));
        DD y = qx.multiply(pw).selfSubtract(px.multiply(qw));
        DD w = px.multiply(qy).selfSubtract(qx.multiply(py));
        double xInt = x.selfDivide(w).doubleValue();
        double yInt = y.selfDivide(w).doubleValue();
        if (Double.isNaN(xInt) || Double.isInfinite(xInt) || Double.isNaN(yInt) || Double.isInfinite(yInt)) {
            return null;
        }
        return new Coordinate(xInt, yInt);
    }
}

