/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.neural;

import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.DenseVectorField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.neural.AbstractVectorQParserBase;

public class KnnQParser
extends AbstractVectorQParserBase {
    protected static final String TOP_K = "topK";
    protected static final int DEFAULT_TOP_K = 10;

    public KnnQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        SchemaField schemaField = this.req.getCore().getLatestSchema().getField(this.getFieldName());
        DenseVectorField denseVectorType = KnnQParser.getCheckedFieldType(schemaField);
        String vectorToSearch = this.getVectorToSearch();
        int topK = this.localParams.getInt(TOP_K, 10);
        return denseVectorType.getKnnVectorQuery(schemaField.getName(), vectorToSearch, topK, this.getFilterQuery());
    }
}

