﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/apigateway/APIGateway_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace APIGateway {
namespace Model {
/**
 * <p>Represents the usage data of a usage plan.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/apigateway-2015-07-09/Usage">AWS
 * API Reference</a></p>
 */
class UpdateUsageResult {
 public:
  AWS_APIGATEWAY_API UpdateUsageResult() = default;
  AWS_APIGATEWAY_API UpdateUsageResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APIGATEWAY_API UpdateUsageResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The plan Id associated with this usage data.</p>
   */
  inline const Aws::String& GetUsagePlanId() const { return m_usagePlanId; }
  template <typename UsagePlanIdT = Aws::String>
  void SetUsagePlanId(UsagePlanIdT&& value) {
    m_usagePlanIdHasBeenSet = true;
    m_usagePlanId = std::forward<UsagePlanIdT>(value);
  }
  template <typename UsagePlanIdT = Aws::String>
  UpdateUsageResult& WithUsagePlanId(UsagePlanIdT&& value) {
    SetUsagePlanId(std::forward<UsagePlanIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The starting date of the usage data.</p>
   */
  inline const Aws::String& GetStartDate() const { return m_startDate; }
  template <typename StartDateT = Aws::String>
  void SetStartDate(StartDateT&& value) {
    m_startDateHasBeenSet = true;
    m_startDate = std::forward<StartDateT>(value);
  }
  template <typename StartDateT = Aws::String>
  UpdateUsageResult& WithStartDate(StartDateT&& value) {
    SetStartDate(std::forward<StartDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ending date of the usage data.</p>
   */
  inline const Aws::String& GetEndDate() const { return m_endDate; }
  template <typename EndDateT = Aws::String>
  void SetEndDate(EndDateT&& value) {
    m_endDateHasBeenSet = true;
    m_endDate = std::forward<EndDateT>(value);
  }
  template <typename EndDateT = Aws::String>
  UpdateUsageResult& WithEndDate(EndDateT&& value) {
    SetEndDate(std::forward<EndDateT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetPosition() const { return m_position; }
  template <typename PositionT = Aws::String>
  void SetPosition(PositionT&& value) {
    m_positionHasBeenSet = true;
    m_position = std::forward<PositionT>(value);
  }
  template <typename PositionT = Aws::String>
  UpdateUsageResult& WithPosition(PositionT&& value) {
    SetPosition(std::forward<PositionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The usage data, as daily logs of used and remaining quotas, over the
   * specified time interval indexed over the API keys in a usage plan. For example,
   * <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>,
   * where <code>{api_key}</code> stands for an API key value and the daily log entry
   * is of the format <code>[used quota, remaining quota]</code>.</p>
   */
  inline const Aws::Map<Aws::String, Aws::Vector<Aws::Vector<long long>>>& GetItems() const { return m_items; }
  template <typename ItemsT = Aws::Map<Aws::String, Aws::Vector<Aws::Vector<long long>>>>
  void SetItems(ItemsT&& value) {
    m_itemsHasBeenSet = true;
    m_items = std::forward<ItemsT>(value);
  }
  template <typename ItemsT = Aws::Map<Aws::String, Aws::Vector<Aws::Vector<long long>>>>
  UpdateUsageResult& WithItems(ItemsT&& value) {
    SetItems(std::forward<ItemsT>(value));
    return *this;
  }
  template <typename ItemsKeyT = Aws::String, typename ItemsValueT = Aws::Vector<Aws::Vector<long long>>>
  UpdateUsageResult& AddItems(ItemsKeyT&& key, ItemsValueT&& value) {
    m_itemsHasBeenSet = true;
    m_items.emplace(std::forward<ItemsKeyT>(key), std::forward<ItemsValueT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateUsageResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_usagePlanId;

  Aws::String m_startDate;

  Aws::String m_endDate;

  Aws::String m_position;

  Aws::Map<Aws::String, Aws::Vector<Aws::Vector<long long>>> m_items;

  Aws::String m_requestId;
  bool m_usagePlanIdHasBeenSet = false;
  bool m_startDateHasBeenSet = false;
  bool m_endDateHasBeenSet = false;
  bool m_positionHasBeenSet = false;
  bool m_itemsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace APIGateway
}  // namespace Aws
