﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/compute-optimizer/ComputeOptimizer_EXPORTS.h>
#include <aws/compute-optimizer/model/LicenseEdition.h>
#include <aws/compute-optimizer/model/LicenseModel.h>
#include <aws/compute-optimizer/model/SavingsOpportunity.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ComputeOptimizer {
namespace Model {

/**
 * <p> Describes the recommendation options for licenses. </p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/LicenseRecommendationOption">AWS
 * API Reference</a></p>
 */
class LicenseRecommendationOption {
 public:
  AWS_COMPUTEOPTIMIZER_API LicenseRecommendationOption() = default;
  AWS_COMPUTEOPTIMIZER_API LicenseRecommendationOption(Aws::Utils::Json::JsonView jsonValue);
  AWS_COMPUTEOPTIMIZER_API LicenseRecommendationOption& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_COMPUTEOPTIMIZER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The rank of the license recommendation option. </p> <p> The top
   * recommendation option is ranked as <code>1</code>. </p>
   */
  inline int GetRank() const { return m_rank; }
  inline bool RankHasBeenSet() const { return m_rankHasBeenSet; }
  inline void SetRank(int value) {
    m_rankHasBeenSet = true;
    m_rank = value;
  }
  inline LicenseRecommendationOption& WithRank(int value) {
    SetRank(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The operating system of a license recommendation option. </p>
   */
  inline const Aws::String& GetOperatingSystem() const { return m_operatingSystem; }
  inline bool OperatingSystemHasBeenSet() const { return m_operatingSystemHasBeenSet; }
  template <typename OperatingSystemT = Aws::String>
  void SetOperatingSystem(OperatingSystemT&& value) {
    m_operatingSystemHasBeenSet = true;
    m_operatingSystem = std::forward<OperatingSystemT>(value);
  }
  template <typename OperatingSystemT = Aws::String>
  LicenseRecommendationOption& WithOperatingSystem(OperatingSystemT&& value) {
    SetOperatingSystem(std::forward<OperatingSystemT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The recommended edition of the license for the application that runs on the
   * instance. </p>
   */
  inline LicenseEdition GetLicenseEdition() const { return m_licenseEdition; }
  inline bool LicenseEditionHasBeenSet() const { return m_licenseEditionHasBeenSet; }
  inline void SetLicenseEdition(LicenseEdition value) {
    m_licenseEditionHasBeenSet = true;
    m_licenseEdition = value;
  }
  inline LicenseRecommendationOption& WithLicenseEdition(LicenseEdition value) {
    SetLicenseEdition(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The recommended license type associated with the instance. </p>
   */
  inline LicenseModel GetLicenseModel() const { return m_licenseModel; }
  inline bool LicenseModelHasBeenSet() const { return m_licenseModelHasBeenSet; }
  inline void SetLicenseModel(LicenseModel value) {
    m_licenseModelHasBeenSet = true;
    m_licenseModel = value;
  }
  inline LicenseRecommendationOption& WithLicenseModel(LicenseModel value) {
    SetLicenseModel(value);
    return *this;
  }
  ///@}

  ///@{

  inline const SavingsOpportunity& GetSavingsOpportunity() const { return m_savingsOpportunity; }
  inline bool SavingsOpportunityHasBeenSet() const { return m_savingsOpportunityHasBeenSet; }
  template <typename SavingsOpportunityT = SavingsOpportunity>
  void SetSavingsOpportunity(SavingsOpportunityT&& value) {
    m_savingsOpportunityHasBeenSet = true;
    m_savingsOpportunity = std::forward<SavingsOpportunityT>(value);
  }
  template <typename SavingsOpportunityT = SavingsOpportunity>
  LicenseRecommendationOption& WithSavingsOpportunity(SavingsOpportunityT&& value) {
    SetSavingsOpportunity(std::forward<SavingsOpportunityT>(value));
    return *this;
  }
  ///@}
 private:
  int m_rank{0};

  Aws::String m_operatingSystem;

  LicenseEdition m_licenseEdition{LicenseEdition::NOT_SET};

  LicenseModel m_licenseModel{LicenseModel::NOT_SET};

  SavingsOpportunity m_savingsOpportunity;
  bool m_rankHasBeenSet = false;
  bool m_operatingSystemHasBeenSet = false;
  bool m_licenseEditionHasBeenSet = false;
  bool m_licenseModelHasBeenSet = false;
  bool m_savingsOpportunityHasBeenSet = false;
};

}  // namespace Model
}  // namespace ComputeOptimizer
}  // namespace Aws
