﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/TestExecutionApiMode.h>
#include <aws/lexv2-models/model/TestExecutionModality.h>
#include <aws/lexv2-models/model/TestExecutionStatus.h>
#include <aws/lexv2-models/model/TestExecutionTarget.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {
class DescribeTestExecutionResult {
 public:
  AWS_LEXMODELSV2_API DescribeTestExecutionResult() = default;
  AWS_LEXMODELSV2_API DescribeTestExecutionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LEXMODELSV2_API DescribeTestExecutionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The execution Id for the test set execution.</p>
   */
  inline const Aws::String& GetTestExecutionId() const { return m_testExecutionId; }
  template <typename TestExecutionIdT = Aws::String>
  void SetTestExecutionId(TestExecutionIdT&& value) {
    m_testExecutionIdHasBeenSet = true;
    m_testExecutionId = std::forward<TestExecutionIdT>(value);
  }
  template <typename TestExecutionIdT = Aws::String>
  DescribeTestExecutionResult& WithTestExecutionId(TestExecutionIdT&& value) {
    SetTestExecutionId(std::forward<TestExecutionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The execution creation date and time for the test set execution.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDateTime() const { return m_creationDateTime; }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  void SetCreationDateTime(CreationDateTimeT&& value) {
    m_creationDateTimeHasBeenSet = true;
    m_creationDateTime = std::forward<CreationDateTimeT>(value);
  }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  DescribeTestExecutionResult& WithCreationDateTime(CreationDateTimeT&& value) {
    SetCreationDateTime(std::forward<CreationDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time of the last update for the execution.</p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdatedDateTime() const { return m_lastUpdatedDateTime; }
  template <typename LastUpdatedDateTimeT = Aws::Utils::DateTime>
  void SetLastUpdatedDateTime(LastUpdatedDateTimeT&& value) {
    m_lastUpdatedDateTimeHasBeenSet = true;
    m_lastUpdatedDateTime = std::forward<LastUpdatedDateTimeT>(value);
  }
  template <typename LastUpdatedDateTimeT = Aws::Utils::DateTime>
  DescribeTestExecutionResult& WithLastUpdatedDateTime(LastUpdatedDateTimeT&& value) {
    SetLastUpdatedDateTime(std::forward<LastUpdatedDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The test execution status for the test execution.</p>
   */
  inline TestExecutionStatus GetTestExecutionStatus() const { return m_testExecutionStatus; }
  inline void SetTestExecutionStatus(TestExecutionStatus value) {
    m_testExecutionStatusHasBeenSet = true;
    m_testExecutionStatus = value;
  }
  inline DescribeTestExecutionResult& WithTestExecutionStatus(TestExecutionStatus value) {
    SetTestExecutionStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The test set Id for the test set execution.</p>
   */
  inline const Aws::String& GetTestSetId() const { return m_testSetId; }
  template <typename TestSetIdT = Aws::String>
  void SetTestSetId(TestSetIdT&& value) {
    m_testSetIdHasBeenSet = true;
    m_testSetId = std::forward<TestSetIdT>(value);
  }
  template <typename TestSetIdT = Aws::String>
  DescribeTestExecutionResult& WithTestSetId(TestSetIdT&& value) {
    SetTestSetId(std::forward<TestSetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The test set name of the test set execution.</p>
   */
  inline const Aws::String& GetTestSetName() const { return m_testSetName; }
  template <typename TestSetNameT = Aws::String>
  void SetTestSetName(TestSetNameT&& value) {
    m_testSetNameHasBeenSet = true;
    m_testSetName = std::forward<TestSetNameT>(value);
  }
  template <typename TestSetNameT = Aws::String>
  DescribeTestExecutionResult& WithTestSetName(TestSetNameT&& value) {
    SetTestSetName(std::forward<TestSetNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The target bot for the test set execution details.</p>
   */
  inline const TestExecutionTarget& GetTarget() const { return m_target; }
  template <typename TargetT = TestExecutionTarget>
  void SetTarget(TargetT&& value) {
    m_targetHasBeenSet = true;
    m_target = std::forward<TargetT>(value);
  }
  template <typename TargetT = TestExecutionTarget>
  DescribeTestExecutionResult& WithTarget(TargetT&& value) {
    SetTarget(std::forward<TargetT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether we use streaming or non-streaming APIs are used for the
   * test set execution. For streaming, <code>StartConversation</code> Amazon Lex
   * Runtime API is used. Whereas for non-streaming, <code>RecognizeUtterance</code>
   * and <code>RecognizeText</code> Amazon Lex Runtime API is used.</p>
   */
  inline TestExecutionApiMode GetApiMode() const { return m_apiMode; }
  inline void SetApiMode(TestExecutionApiMode value) {
    m_apiModeHasBeenSet = true;
    m_apiMode = value;
  }
  inline DescribeTestExecutionResult& WithApiMode(TestExecutionApiMode value) {
    SetApiMode(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether test set is audio or text.</p>
   */
  inline TestExecutionModality GetTestExecutionModality() const { return m_testExecutionModality; }
  inline void SetTestExecutionModality(TestExecutionModality value) {
    m_testExecutionModalityHasBeenSet = true;
    m_testExecutionModality = value;
  }
  inline DescribeTestExecutionResult& WithTestExecutionModality(TestExecutionModality value) {
    SetTestExecutionModality(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Reasons for the failure of the test set execution.</p>
   */
  inline const Aws::Vector<Aws::String>& GetFailureReasons() const { return m_failureReasons; }
  template <typename FailureReasonsT = Aws::Vector<Aws::String>>
  void SetFailureReasons(FailureReasonsT&& value) {
    m_failureReasonsHasBeenSet = true;
    m_failureReasons = std::forward<FailureReasonsT>(value);
  }
  template <typename FailureReasonsT = Aws::Vector<Aws::String>>
  DescribeTestExecutionResult& WithFailureReasons(FailureReasonsT&& value) {
    SetFailureReasons(std::forward<FailureReasonsT>(value));
    return *this;
  }
  template <typename FailureReasonsT = Aws::String>
  DescribeTestExecutionResult& AddFailureReasons(FailureReasonsT&& value) {
    m_failureReasonsHasBeenSet = true;
    m_failureReasons.emplace_back(std::forward<FailureReasonsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeTestExecutionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_testExecutionId;

  Aws::Utils::DateTime m_creationDateTime{};

  Aws::Utils::DateTime m_lastUpdatedDateTime{};

  TestExecutionStatus m_testExecutionStatus{TestExecutionStatus::NOT_SET};

  Aws::String m_testSetId;

  Aws::String m_testSetName;

  TestExecutionTarget m_target;

  TestExecutionApiMode m_apiMode{TestExecutionApiMode::NOT_SET};

  TestExecutionModality m_testExecutionModality{TestExecutionModality::NOT_SET};

  Aws::Vector<Aws::String> m_failureReasons;

  Aws::String m_requestId;
  bool m_testExecutionIdHasBeenSet = false;
  bool m_creationDateTimeHasBeenSet = false;
  bool m_lastUpdatedDateTimeHasBeenSet = false;
  bool m_testExecutionStatusHasBeenSet = false;
  bool m_testSetIdHasBeenSet = false;
  bool m_testSetNameHasBeenSet = false;
  bool m_targetHasBeenSet = false;
  bool m_apiModeHasBeenSet = false;
  bool m_testExecutionModalityHasBeenSet = false;
  bool m_failureReasonsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
