/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.RemoveOnlyCollection;
import org.knopflerfish.framework.ServiceListenerEntry;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class ServiceHooks {
    private final FrameworkContext fwCtx;
    ServiceTracker<ListenerHook, ListenerHook> listenerHookTracker;
    boolean bOpen;

    ServiceHooks(FrameworkContext fwCtx) {
        this.fwCtx = fwCtx;
    }

    synchronized void open() {
        if (this.fwCtx.debug.hooks) {
            this.fwCtx.debug.println("opening hooks");
        }
        this.listenerHookTracker = new ServiceTracker<ListenerHook, ListenerHook>((BundleContext)this.fwCtx.systemBundle.bundleContext, ListenerHook.class, new ServiceTrackerCustomizer<ListenerHook, ListenerHook>(){

            @Override
            public ListenerHook addingService(ServiceReference<ListenerHook> reference) {
                ListenerHook lh = ((ServiceHooks)ServiceHooks.this).fwCtx.systemBundle.bundleContext.getService(reference);
                try {
                    Collection<ListenerHook.ListenerInfo> c;
                    Collection<ListenerHook.ListenerInfo> li = c = ServiceHooks.this.getServiceCollection();
                    lh.added(li);
                }
                catch (Exception e) {
                    ((ServiceHooks)ServiceHooks.this).fwCtx.debug.printStackTrace("Failed to call listener hook  #" + reference.getProperty("service.id"), e);
                }
                return lh;
            }

            @Override
            public void modifiedService(ServiceReference<ListenerHook> reference, ListenerHook service) {
            }

            @Override
            public void removedService(ServiceReference<ListenerHook> reference, ListenerHook service) {
                ((ServiceHooks)ServiceHooks.this).fwCtx.systemBundle.bundleContext.ungetService(reference);
            }
        });
        this.listenerHookTracker.open();
        this.bOpen = true;
    }

    synchronized void close() {
        this.listenerHookTracker.close();
        this.listenerHookTracker = null;
        this.bOpen = false;
    }

    public synchronized boolean isOpen() {
        return this.bOpen;
    }

    void filterServiceReferences(BundleContextImpl bc, String service, String filter, boolean allServices, Collection<ServiceReference<?>> refs) {
        List<ServiceRegistrationImpl<?>> srl = this.fwCtx.services.get(FindHook.class.getName());
        if (srl != null) {
            RemoveOnlyCollection filtered = new RemoveOnlyCollection(refs);
            for (ServiceRegistrationImpl<?> fhr : srl) {
                ServiceReferenceImpl sr = fhr.reference;
                FindHook fh = (FindHook)sr.getService();
                if (fh == null) continue;
                try {
                    fh.find(bc, service, filter, allServices, filtered);
                }
                catch (Exception e) {
                    this.fwCtx.frameworkError(bc, (Throwable)new BundleException("Failed to call find hook  #" + sr.getProperty("service.id"), e), new FrameworkListener[0]);
                }
            }
        }
    }

    void filterServiceEventReceivers(ServiceEvent evt, Collection<ServiceListenerEntry> receivers) {
        List<ServiceRegistrationImpl<?>> eventListenerHooks;
        List<ServiceRegistrationImpl<?>> eventHooks = this.fwCtx.services.get(EventHook.class.getName());
        if (eventHooks != null) {
            HashSet<BundleContext> ctxs = new HashSet<BundleContext>();
            for (ServiceListenerEntry sle : receivers) {
                ctxs.add(sle.getBundleContext());
            }
            int start_size = ctxs.size();
            RemoveOnlyCollection<BundleContext> filtered = new RemoveOnlyCollection<BundleContext>(ctxs);
            for (ServiceRegistrationImpl<?> serviceRegistrationImpl : eventHooks) {
                ServiceReferenceImpl sr = serviceRegistrationImpl.reference;
                EventHook eh = (EventHook)sr.getService();
                if (eh == null) continue;
                try {
                    eh.event(evt, filtered);
                }
                catch (Exception e) {
                    this.fwCtx.debug.printStackTrace("Failed to call event hook  #" + sr.getProperty("service.id"), e);
                }
            }
            if (start_size != ctxs.size()) {
                ctxs.add(this.fwCtx.systemBundle.bundleContext);
                Iterator<ServiceListenerEntry> ir = receivers.iterator();
                while (ir.hasNext()) {
                    if (ctxs.contains(ir.next().getBundleContext())) continue;
                    ir.remove();
                }
            }
        }
        if ((eventListenerHooks = this.fwCtx.services.get(EventListenerHook.class.getName())) != null) {
            HashMap listeners = new HashMap();
            for (ServiceListenerEntry sle : receivers) {
                if (!listeners.containsKey(sle.getBundleContext())) {
                    listeners.put(sle.getBundleContext(), new ArrayList());
                }
                ((Collection)listeners.get(sle.getBundleContext())).add(sle);
            }
            receivers.clear();
            Collection sys = (Collection)listeners.get(this.fwCtx.systemBundle.bundleContext);
            if (sys != null) {
                Collection sles = sys;
                receivers.addAll(sles);
            }
            for (Map.Entry entry : listeners.entrySet()) {
                entry.setValue(new RemoveOnlyCollection((Collection)entry.getValue()));
            }
            RemoveOnlyMap<BundleContext, Collection<ListenerHook.ListenerInfo>> filtered = new RemoveOnlyMap<BundleContext, Collection<ListenerHook.ListenerInfo>>(listeners);
            for (ServiceRegistrationImpl<?> sri : eventListenerHooks) {
                EventListenerHook elh = (EventListenerHook)sri.reference.getService();
                if (elh == null) continue;
                try {
                    elh.event(evt, filtered);
                }
                catch (Exception e) {
                    this.fwCtx.debug.printStackTrace("Failed to call event hook  #" + sri.reference.getProperty("service.id"), e);
                }
            }
            Iterator iterator = listeners.values().iterator();
            while (iterator.hasNext()) {
                Collection li;
                Collection sles = li = (Collection)iterator.next();
                receivers.addAll(sles);
            }
        }
    }

    Collection<ServiceListenerEntry> getServiceCollection() {
        return Collections.unmodifiableSet(this.fwCtx.listeners.serviceListeners.serviceSet);
    }

    void handleServiceListenerReg(ServiceListenerEntry sle) {
        if (!this.isOpen() || this.listenerHookTracker.size() == 0) {
            return;
        }
        ServiceReference<ListenerHook>[] srl = this.listenerHookTracker.getServiceReferences();
        Set<ListenerHook.ListenerInfo> set = ServiceHooks.toImmutableSet(sle);
        if (srl != null) {
            for (ServiceReference<ListenerHook> sr : srl) {
                ListenerHook lh = this.listenerHookTracker.getService(sr);
                try {
                    lh.added(set);
                }
                catch (Exception e) {
                    this.fwCtx.debug.printStackTrace("Failed to call listener hook #" + sr.getProperty("service.id"), e);
                }
            }
        }
    }

    void handleServiceListenerUnreg(ServiceListenerEntry sle) {
        if (this.isOpen()) {
            this.handleServiceListenerUnreg(ServiceHooks.toImmutableSet(sle));
        }
    }

    void handleServiceListenerUnreg(Collection<ServiceListenerEntry> set) {
        if (!this.isOpen() || this.listenerHookTracker.size() == 0) {
            return;
        }
        ServiceReference<ListenerHook>[] srl = this.listenerHookTracker.getServiceReferences();
        if (srl != null) {
            Collection<ListenerHook.ListenerInfo> lis = set;
            for (ServiceReference<ListenerHook> sr : srl) {
                ListenerHook lh = this.listenerHookTracker.getService(sr);
                try {
                    lh.removed(lis);
                }
                catch (Exception e) {
                    this.fwCtx.debug.printStackTrace("Failed to call listener hook #" + sr.getProperty("service.id"), e);
                }
            }
        }
    }

    static <E> Set<E> toImmutableSet(E obj) {
        Set<E> set = new HashSet<E>();
        set.add(obj);
        set = Collections.unmodifiableSet(set);
        return set;
    }

    static class RemoveOnlyMap<K, V>
    implements Map<K, V> {
        final Map<K, V> original;

        public RemoveOnlyMap(Map<K, V> original) {
            this.original = original;
        }

        @Override
        public void clear() {
            this.original.clear();
        }

        @Override
        public boolean containsKey(Object k) {
            return this.original.containsKey(k);
        }

        @Override
        public boolean containsValue(Object v) {
            return this.original.containsValue(v);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.original.entrySet();
        }

        @Override
        public V get(Object k) {
            return this.original.get(k);
        }

        @Override
        public boolean isEmpty() {
            return this.original.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return this.original.keySet();
        }

        @Override
        public V put(Object k, Object v) {
            throw new UnsupportedOperationException("objects can only be removed");
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException("objects can only be removed");
        }

        @Override
        public V remove(Object k) {
            return this.original.remove(k);
        }

        @Override
        public int size() {
            return this.original.size();
        }

        @Override
        public Collection<V> values() {
            return this.original.values();
        }
    }
}

