/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.conditions.AllAttributesMatchCondition;
import com.tngtech.archunit.lang.conditions.DependencyCondition;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class AllDependenciesCondition
extends AllAttributesMatchCondition<Dependency, JavaClass> {
    private final DescribedPredicate<? super Dependency> conditionPredicate;
    private final Function<JavaClass, ? extends Collection<Dependency>> javaClassToRelevantDependencies;
    private final DescribedPredicate<Dependency> ignorePredicate;

    AllDependenciesCondition(String description, DescribedPredicate<? super Dependency> predicate, Function<JavaClass, ? extends Collection<Dependency>> javaClassToRelevantDependencies) {
        this(description, predicate, javaClassToRelevantDependencies, DescribedPredicate.alwaysFalse());
    }

    private AllDependenciesCondition(String description, DescribedPredicate<? super Dependency> conditionPredicate, Function<JavaClass, ? extends Collection<Dependency>> javaClassToRelevantDependencies, DescribedPredicate<Dependency> ignorePredicate) {
        super(description, new DependencyCondition(conditionPredicate));
        this.conditionPredicate = Preconditions.checkNotNull(conditionPredicate);
        this.javaClassToRelevantDependencies = Preconditions.checkNotNull(javaClassToRelevantDependencies);
        this.ignorePredicate = Preconditions.checkNotNull(ignorePredicate);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public AllDependenciesCondition ignoreDependency(DescribedPredicate<? super Dependency> ignorePredicate) {
        return new AllDependenciesCondition(this.getDescription(), this.conditionPredicate, this.javaClassToRelevantDependencies, this.ignorePredicate.or(ignorePredicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public AllDependenciesCondition as(String description, Object ... args) {
        return new AllDependenciesCondition(String.format(description, args), this.conditionPredicate, this.javaClassToRelevantDependencies, this.ignorePredicate);
    }

    @Override
    Collection<Dependency> relevantAttributes(JavaClass javaClass) {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (Dependency dependency : this.javaClassToRelevantDependencies.apply(javaClass)) {
            if (this.ignorePredicate.test(dependency)) continue;
            result.add(dependency);
        }
        return result;
    }
}

